/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.ksb.api.bus.support.AbstractServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.RestServiceDefinition;

@XmlRootElement(name="restServiceConfiguration")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RestServiceConfigurationType", propOrder={"resourceClass", "resourceToClassNameMap"})
public final class RestServiceConfiguration
extends AbstractServiceConfiguration {
    private static final long serialVersionUID = -4226512121638441108L;
    @XmlElement(name="resourceClass", required=false)
    private final String resourceClass;
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    @XmlElement(name="resourceToClassNameMap", required=false)
    private final Map<String, String> resourceToClassNameMap;

    private RestServiceConfiguration() {
        this.resourceClass = null;
        this.resourceToClassNameMap = null;
    }

    private RestServiceConfiguration(Builder builder) {
        super(builder);
        this.resourceClass = builder.getResourceClass();
        this.resourceToClassNameMap = builder.getResourceToClassNameMap() != null ? new HashMap<String, String>(builder.getResourceToClassNameMap()) : Collections.emptyMap();
    }

    public static RestServiceConfiguration fromServiceDefinition(RestServiceDefinition restServiceDefinition) {
        return Builder.create(restServiceDefinition).build();
    }

    public String getResourceClass() {
        return this.resourceClass;
    }

    public Map<String, String> getResourceToClassNameMap() {
        return this.resourceToClassNameMap;
    }

    public boolean hasClass(String className) {
        if (this.resourceToClassNameMap == null) {
            return false;
        }
        return this.resourceToClassNameMap.containsValue(className);
    }

    static class Elements {
        protected static final String RESOURCE_CLASS = "resourceClass";
        protected static final String RESOURCE_TO_CLASS_NAME_MAP = "resourceToClassNameMap";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "restServiceConfiguration";
        static final String TYPE_NAME = "RestServiceConfigurationType";

        Constants() {
        }
    }

    public static final class Builder
    extends AbstractServiceConfiguration.Builder<RestServiceConfiguration> {
        private static final long serialVersionUID = 4300659121377259098L;
        private String resourceClass;
        private Map<String, String> resourceToClassNameMap;

        public String getResourceClass() {
            return this.resourceClass;
        }

        public void setResourceClass(String resourceClass) {
            this.resourceClass = resourceClass;
        }

        public Map<String, String> getResourceToClassNameMap() {
            return this.resourceToClassNameMap;
        }

        public void setResourceToClassNameMap(Map<String, String> resourceToClassNameMap) {
            this.resourceToClassNameMap = resourceToClassNameMap;
        }

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(RestServiceDefinition restServiceDefinition) {
            Builder builder = Builder.create();
            builder.copyServiceDefinitionProperties(restServiceDefinition);
            builder.setResourceClass(restServiceDefinition.getResourceClass());
            if (restServiceDefinition.getResourceToClassNameMap() != null) {
                builder.setResourceToClassNameMap(restServiceDefinition.getResourceToClassNameMap());
            }
            return builder;
        }

        @Override
        public RestServiceConfiguration build() {
            return new RestServiceConfiguration(this);
        }
    }
}

