/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.LockStrategy;
import org.apache.ojb.odmg.locking.ReadCommittedStrategy;
import org.apache.ojb.odmg.locking.ReadUncommittedStrategy;
import org.apache.ojb.odmg.locking.RepeatableReadStrategy;
import org.apache.ojb.odmg.locking.SerializableStrategy;

public class LockStrategyFactory {
    private static LockStrategy readUncommitedStrategy = new ReadUncommittedStrategy();
    private static LockStrategy readCommitedStrategy = new ReadCommittedStrategy();
    private static LockStrategy readRepeatableStrategy = new RepeatableReadStrategy();
    private static LockStrategy serializableStrategy = new SerializableStrategy();
    private static LockStrategy noopStrategy = new NOOPStrategy();

    private LockStrategyFactory() {
    }

    public static LockStrategy getStrategyFor(Object object) {
        int n = LockStrategyFactory.getIsolationLevel(object);
        switch (n) {
            case 2: {
                return readUncommitedStrategy;
            }
            case 3: {
                return readCommitedStrategy;
            }
            case 5: {
                return readRepeatableStrategy;
            }
            case 7: {
                return serializableStrategy;
            }
            case 4: {
                return noopStrategy;
            }
            case -1: {
                return noopStrategy;
            }
        }
        return readUncommitedStrategy;
    }

    public static int getIsolationLevel(Object object) {
        Class clazz = ProxyHelper.getRealClass(object);
        int n = 2;
        try {
            ClassDescriptor classDescriptor = TxManagerFactory.instance().getCurrentTransaction().getBroker().getClassDescriptor(clazz);
            n = classDescriptor.getIsolationLevel();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            LoggerFactory.getDefaultLogger().error("[LockStrategyFactory] Can't detect locking isolation level", (Throwable)((Object)persistenceBrokerException));
        }
        return n;
    }

    static class NOOPStrategy
    implements LockStrategy {
        NOOPStrategy() {
        }

        @Override
        public boolean readLock(TransactionImpl transactionImpl, Object object) {
            return true;
        }

        @Override
        public boolean writeLock(TransactionImpl transactionImpl, Object object) {
            return true;
        }

        @Override
        public boolean upgradeLock(TransactionImpl transactionImpl, Object object) {
            return true;
        }

        @Override
        public boolean releaseLock(TransactionImpl transactionImpl, Object object) {
            return false;
        }

        @Override
        public boolean checkRead(TransactionImpl transactionImpl, Object object) {
            return false;
        }

        @Override
        public boolean checkWrite(TransactionImpl transactionImpl, Object object) {
            return false;
        }
    }
}

