/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.citi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiMap;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class PersonTrainingCitiMapRules
extends KcMaintenanceDocumentRuleBase {
    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    private boolean checkUniqueness(MaintenanceDocument maintenanceDocument) {
        PersonTrainingCitiMap personTrainingCitiMap = (PersonTrainingCitiMap)maintenanceDocument.getNewMaintainableObject().getDataObject();
        boolean valid = true;
        if (personTrainingCitiMap.getTrainingCode() != null && this.differentId(personTrainingCitiMap, this.getBoService().findMatching(PersonTrainingCitiMap.class, Collections.singletonMap("trainingCode", personTrainingCitiMap.getTrainingCode())))) {
            valid = false;
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError("document.newMaintainableObject.trainingCode", "error.citi.map.duplicate.training.code", new String[]{personTrainingCitiMap.getTrainingCode().toString()});
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("groupId", personTrainingCitiMap.getGroupId());
        criteria.put("stageNumber", personTrainingCitiMap.getStageNumber());
        if (this.differentId(personTrainingCitiMap, this.getBoService().findMatching(PersonTrainingCitiMap.class, criteria))) {
            valid = false;
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError("document.newMaintainableObject.groupId", "error.citi.map.duplicate.group.stage", new String[]{personTrainingCitiMap.getGroupId(), personTrainingCitiMap.getStageNumber()});
        }
        return valid;
    }

    private boolean differentId(PersonTrainingCitiMap personTrainingCitiMap, Collection<PersonTrainingCitiMap> mappings) {
        return mappings.stream().filter(map -> !map.getId().equals(personTrainingCitiMap.getId())).findAny().isPresent();
    }
}

