/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.core;

import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireAuthorizationService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="questionnaireAuthorizationService")
public class QuestionnaireAuthorizationServiceImpl
implements QuestionnaireAuthorizationService {
    @Autowired
    @Qualifier(value="unitAuthorizationService")
    private UnitAuthorizationService unitAuthorizationService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public boolean hasPermission(String permissionName) {
        KcPerson person = this.kcPersonService.getKcPersonByUserName(this.getUserName());
        return this.unitAuthorizationService.hasPermission(person.getPersonId(), "KC-QUESTIONNAIRE", permissionName);
    }

    protected String getUserName() {
        return this.globalVariableService.getUserSession().getPerson().getPrincipalName();
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        return this.unitAuthorizationService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

