/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.participant;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.irb.protocol.participant.AddProtocolParticipantEvent;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolParticipantRuleBase
extends KcTransactionalDocumentRuleBase {
    private static final String DOT = ".";
    private static final String PARTICIPANT_TYPE_CODE_FIELD = "participantTypeCode";
    private DictionaryValidationService dictionaryValidationService;

    public boolean processAddProtocolParticipantEvent(AddProtocolParticipantEvent addProtocolParticipantEvent) {
        boolean rulePassed = true;
        ProtocolParticipant newProtocolParticipant = addProtocolParticipantEvent.getNewProtocolParticipant();
        List<ProtocolParticipant> protocolParticipants = addProtocolParticipantEvent.getProtocolParticipants();
        String errorPath = addProtocolParticipantEvent.getErrorPathPrefix();
        this.getKnsDictionaryValidationService().validateBusinessObject((Object)newProtocolParticipant);
        rulePassed &= GlobalVariables.getMessageMap().hasNoErrors();
        return rulePassed &= this.validateUniqueParticipantType(newProtocolParticipant, protocolParticipants, errorPath);
    }

    private boolean validateUniqueParticipantType(ProtocolParticipant newProtocolParticipant, List<ProtocolParticipant> protocolParticipants, String errorPath) {
        boolean isValid = true;
        for (ProtocolParticipant protocolParticipant : protocolParticipants) {
            if (!StringUtils.equals((CharSequence)protocolParticipant.getParticipantTypeCode(), (CharSequence)newProtocolParticipant.getParticipantTypeCode())) continue;
            isValid = false;
            this.reportError(errorPath + ".participantTypeCode", "error.protocol.participantType.duplicate", new String[0]);
            break;
        }
        return isValid;
    }

    @Override
    protected DictionaryValidationService getKnsDictionaryValidationService() {
        if (this.dictionaryValidationService == null) {
            this.dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return this.dictionaryValidationService;
    }
}

