/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.permissions.impl.web.struts.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.permissions.impl.bo.PermissionsRoleState;
import org.kuali.coeus.common.permissions.impl.bo.PermissionsUser;
import org.kuali.coeus.common.permissions.impl.bo.PermissionsUserEditRoles;
import org.kuali.coeus.common.permissions.impl.rule.event.AddPermissionsUserEvent;
import org.kuali.coeus.common.permissions.impl.rule.event.DeletePermissionsUserEvent;
import org.kuali.coeus.common.permissions.impl.rule.event.EditUserPermissionsRolesEvent;
import org.kuali.coeus.common.permissions.impl.web.bean.Role;
import org.kuali.coeus.common.permissions.impl.web.bean.RoleState;
import org.kuali.coeus.common.permissions.impl.web.bean.User;
import org.kuali.coeus.common.permissions.impl.web.bean.UserState;
import org.kuali.coeus.common.permissions.impl.web.struts.form.PermissionsForm;
import org.kuali.coeus.common.permissions.impl.web.struts.form.PermissionsHelperBase;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public abstract class PermissionsActionHelperBase
implements Serializable {
    private static final String ADD_USER_METHOD = "addUser";
    private static final String DELETE_USER_METHOD = "deleteUser";
    private static final String SET_EDIT_ROLES_METHOD = "setEditRoles";
    private KcTransactionalDocumentActionBase parentAction;

    protected PermissionsActionHelperBase(KcTransactionalDocumentActionBase parentAction) {
        this.parentAction = parentAction;
    }

    protected abstract void addUserToRoleInDatabase(Document var1, String var2, String var3);

    protected abstract void removeUserFromRoleInDatabase(Document var1, String var2, String var3);

    public void save(PermissionsForm form) throws Exception {
        List<UserState> userStates = form.getPermissionsHelper().getUserStates();
        this.removeRolesFromUsers(form.getDocument(), userStates);
        this.addRolesToUsers(form.getDocument(), userStates);
        this.removeUsersWithNoRoles(userStates);
    }

    private void removeRolesFromUsers(Document document, List<UserState> userStates) {
        for (UserState userState : userStates) {
            List<RoleState> roleStates = userState.getRoleStates();
            for (RoleState roleState : roleStates) {
                if (!roleState.needsToBeRemoved()) continue;
                this.removeUserFromRoleInDatabase(document, userState.getPerson().getPersonId(), roleState.getRole().getName());
                roleState.setSaved(false);
            }
        }
    }

    private void addRolesToUsers(Document document, List<UserState> userStates) {
        for (UserState userState : userStates) {
            List<RoleState> roleStates = userState.getRoleStates();
            for (RoleState roleState : roleStates) {
                if (!roleState.needsToBeAdded()) continue;
                this.addUserToRoleInDatabase(document, userState.getPerson().getPersonId(), roleState.getRole().getName());
                roleState.setSaved(true);
            }
        }
    }

    private void removeUsersWithNoRoles(List<UserState> userStates) {
        Iterator<UserState> iter = userStates.iterator();
        while (iter.hasNext()) {
            UserState userState = iter.next();
            if (userState.hasAnyRole()) continue;
            iter.remove();
        }
    }

    public ActionForward getRoleRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("permissionsRoleRights");
    }

    public final ActionForward addUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PermissionsForm permissionsForm = (PermissionsForm)form;
        PermissionsHelperBase permissionsHelper = permissionsForm.getPermissionsHelper();
        Document doc = permissionsForm.getDocument();
        if (!permissionsHelper.canModifyPermissions()) {
            return this.parentAction.processAuthorizationViolation(ADD_USER_METHOD, mapping, form, request, response);
        }
        PermissionsUser newUser = permissionsForm.getPermissionsHelper().getNewUser();
        boolean rulePassed = this.applyRules((DocumentEvent)new AddPermissionsUserEvent(doc, permissionsForm.getPermissionsHelper().getUsers(), newUser));
        if (rulePassed) {
            permissionsForm.getPermissionsHelper().addNewUser();
        }
        return mapping.findForward("basic");
    }

    public final ActionForward deleteUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        PermissionsForm permissionsForm = (PermissionsForm)form;
        PermissionsHelperBase permissionsHelper = permissionsForm.getPermissionsHelper();
        Document doc = permissionsForm.getDocument();
        if (!permissionsHelper.canModifyPermissions()) {
            actionForward = this.parentAction.processAuthorizationViolation(DELETE_USER_METHOD, mapping, form, request, response);
        } else {
            int lineNum = this.getLineToDelete(request);
            List<User> users = permissionsForm.getPermissionsHelper().getUsers();
            boolean rulePassed = this.applyRules((DocumentEvent)new DeletePermissionsUserEvent(doc, users, lineNum));
            if (rulePassed) {
                actionForward = this.parentAction.confirm(this.buildDeleteUserConfirmationQuestion(mapping, form, request, response), "confirmDeletePermissionsUser", "");
            }
        }
        return actionForward;
    }

    public ActionForward confirmDeletePermissionsUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("confirmDeletePermissionsUser".equals(question)) {
            PermissionsForm permissionsForm = (PermissionsForm)form;
            int lineNum = this.getLineToDelete(request);
            User user = permissionsForm.getPermissionsHelper().getUsers().get(lineNum);
            UserState userState = permissionsForm.getPermissionsHelper().getUserState(user.getPerson().getUserName());
            if (userState != null) {
                userState.clearAssignments();
            }
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDeleteUserConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PermissionsForm permissionsForm = (PermissionsForm)form;
        String fullname = permissionsForm.getPermissionsHelper().getUsers().get(this.getLineToDelete(request)).getPerson().getFullName();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "confirmDeletePermissionsUser", "document.question.deleteProposalUser.text", fullname);
    }

    private StrutsConfirmation buildParameterizedConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String configurationId, String ... params) throws Exception {
        StrutsConfirmation retval = new StrutsConfirmation();
        retval.setMapping(mapping);
        retval.setForm(form);
        retval.setRequest(request);
        retval.setResponse(response);
        retval.setQuestionId(questionId);
        retval.setQuestionType("confirmationQuestion");
        ConfigurationService kualiConfiguration = CoreApiServiceLocator.getKualiConfigurationService();
        String questionText = kualiConfiguration.getPropertyValueAsString(configurationId);
        for (int i = 0; i < params.length; ++i) {
            questionText = StringUtils.replace((String)questionText, (String)("{" + i + "}"), (String)params[i]);
        }
        retval.setQuestionText(questionText);
        return retval;
    }

    public ActionForward editRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PermissionsForm permissionsForm = (PermissionsForm)form;
        PermissionsHelperBase permissionsHelper = permissionsForm.getPermissionsHelper();
        int lineNum = this.getLineNum(request);
        User user = permissionsHelper.getUsers().get(lineNum);
        PermissionsUserEditRoles editRoles = new PermissionsUserEditRoles();
        editRoles.setLineNum(lineNum);
        editRoles.setJavaScriptEnabled(this.isJavaScriptEnabled(request));
        editRoles.setUserName(user.getPerson().getUserName());
        editRoles.setPrinipalInvestigator(this.isPrincipalInvestigator((ProtocolDocument)permissionsForm.getDocument(), user.getPerson().getPersonId()));
        ArrayList<PermissionsRoleState> roleStates = new ArrayList<PermissionsRoleState>();
        List<Role> roles = permissionsHelper.getNormalRoles();
        for (Role role : roles) {
            PermissionsRoleState roleState = new PermissionsRoleState(role);
            roleStates.add(roleState);
        }
        editRoles.setRoleStates(roleStates);
        List<Role> userRoles = user.getRoles();
        for (Role userRole : userRoles) {
            editRoles.setRoleState(userRole.getName(), Boolean.TRUE);
        }
        permissionsHelper.setUserEditRoles(editRoles);
        return mapping.findForward("permissionsEditRoles");
    }

    public ActionForward setEditRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = null;
        PermissionsHelperBase permissionsHelper = ((PermissionsForm)form).getPermissionsHelper();
        PermissionsForm permissionsForm = (PermissionsForm)form;
        Document doc = permissionsForm.getDocument();
        if (!permissionsHelper.canModifyPermissions()) {
            return this.parentAction.processAuthorizationViolation(SET_EDIT_ROLES_METHOD, mapping, form, request, response);
        }
        PermissionsUserEditRoles editRoles = permissionsHelper.getEditRoles();
        boolean rulePassed = this.applyRules((DocumentEvent)new EditUserPermissionsRolesEvent(doc, permissionsHelper.getUsers(), editRoles));
        if (!rulePassed) {
            actionForward = mapping.findForward("permissionsEditRoles");
        } else {
            this.updateRoles(editRoles, permissionsHelper);
            actionForward = editRoles.getJavaScriptEnabled() ? mapping.findForward("permissionsCloseEditRoles") : mapping.findForward("basic");
        }
        return actionForward;
    }

    private void updateRoles(PermissionsUserEditRoles editRoles, PermissionsHelperBase permissionsHelper) {
        UserState userState = permissionsHelper.getUserState(editRoles.getUserName());
        userState.clearAssignments();
        List<PermissionsRoleState> roleStates = editRoles.getRoleStates();
        for (PermissionsRoleState roleState : roleStates) {
            if (!roleState.getState().booleanValue()) continue;
            userState.setAssigned(roleState.getRole().getName(), true);
        }
        if (!userState.hasAnyRole() && permissionsHelper.getUnassignedRoleName() != null) {
            userState.setAssigned(permissionsHelper.getUnassignedRoleName(), true);
        }
    }

    private int getLineNum(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            return Integer.parseInt(lineNumStr);
        }
        catch (Exception ex) {
            return this.getLineToDelete(request);
        }
    }

    private boolean isJavaScriptEnabled(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            Integer.parseInt(lineNumStr);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private int getLineToDelete(HttpServletRequest request) {
        return this.getSelectedLine(request);
    }

    private int getSelectedLine(HttpServletRequest request) {
        int selectedLine = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String lineNumber = StringUtils.substringBetween((String)parameterName, (String)".line", (String)".");
            selectedLine = Integer.parseInt(lineNumber);
        }
        return selectedLine;
    }

    private KualiRuleService getKualiRuleService() {
        return KcServiceLocator.getService(KualiRuleService.class);
    }

    protected final boolean applyRules(DocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    private boolean isPrincipalInvestigator(ProtocolDocument protocolDocument, String personId) {
        return StringUtils.equals((CharSequence)personId, (CharSequence)protocolDocument.getProtocol().getPrincipalInvestigatorId());
    }
}

