/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.protocol.actions.submit.ProtocolActionMappingBase;

public class IacucProtocolActionMapping
extends ProtocolActionMappingBase {
    private static final Map<String, String> ACTION_TYPE_SUBMISSION_TYPE_MAP;

    public IacucProtocolActionMapping(String actionTypeCode, String submissionStatusCode, String submissionTypeCode, String protocolReviewTypeCode, String protocolStatusCode, String scheduleId, Integer submissionNumber) {
        super(actionTypeCode, submissionStatusCode, submissionTypeCode, protocolReviewTypeCode, protocolStatusCode, scheduleId, submissionNumber);
    }

    @Override
    public boolean getSubmissionCount() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", this.getPendingSubmissionStatusCodes());
        HashMap<String, String> negativeFieldValues = new HashMap<String, String>();
        negativeFieldValues.put("submissionTypeCode", ACTION_TYPE_SUBMISSION_TYPE_MAP.get(this.actionTypeCode));
        return this.businessObjectService.countMatching(IacucProtocolSubmission.class, positiveFieldValues, negativeFieldValues) == 0;
    }

    @Override
    public boolean getSubmissionCountCond2() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", this.getPendingSubmissionStatusCodes());
        return this.businessObjectService.countMatching(IacucProtocolSubmission.class, positiveFieldValues) == 0;
    }

    @Override
    public boolean getSubmissionCountCond4() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", this.getPendingSubmissionStatusCodes());
        positiveFieldValues.put("submissionTypeCode", Arrays.asList("102", "103"));
        return this.businessObjectService.countMatching(IacucProtocolSubmission.class, positiveFieldValues) == 0;
    }

    private List<String> getPendingSubmissionStatusCodes() {
        ArrayList<String> submissionStatusCodes = new ArrayList<String>();
        submissionStatusCodes.add("102");
        submissionStatusCodes.add("103");
        submissionStatusCodes.add("101");
        return submissionStatusCodes;
    }

    @Override
    public boolean getSubmissionCountCond5() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        List submissions = (List)this.businessObjectService.findMatchingOrderBy(IacucProtocolSubmission.class, positiveFieldValues, "submissionNumber", false);
        return submissions.isEmpty() || !this.getPendingSubmissionStatusCodes().contains(((IacucProtocolSubmission)submissions.get(0)).getSubmissionStatusCode());
    }

    public boolean isAnySubmissionRequests() {
        List<String> submissionTypes = Arrays.asList("111", "103", "102");
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", "101");
        positiveFieldValues.put("submissionTypeCode", submissionTypes);
        List submissions = (List)this.businessObjectService.findMatchingOrderBy(IacucProtocolSubmission.class, positiveFieldValues, "submissionNumber", false);
        return submissions.size() > 0;
    }

    @Override
    public boolean getSubmissionCountForWithdraw() {
        List<String> statusCodes = Arrays.asList("101", "102", "103");
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        List submissions = (List)this.businessObjectService.findMatchingOrderBy(IacucProtocolSubmission.class, positiveFieldValues, "submissionNumber", false);
        return !submissions.isEmpty() && statusCodes.contains(((IacucProtocolSubmission)submissions.get(0)).getSubmissionStatusCode());
    }

    public String toString() {
        return "IacucProtocolActionMapping = (submissionStatusCode = " + this.submissionStatusCode + ", submissionTypeCode = " + this.submissionTypeCode + ", protocolReviewTypeCode = " + this.protocolReviewTypeCode + ", actionTypeCode = " + this.actionTypeCode + ", protocolStatusCode = " + this.protocolStatusCode + ", scheduleId = " + this.scheduleId + ", protocol id = " + this.protocol.getProtocolId() + ", submissionNumber = " + this.submissionNumber + ", allowed = " + this.allowed + ")";
    }

    public boolean getSubmissionStatusForAdminAction() {
        boolean retVal = StringUtils.isNotBlank((CharSequence)this.protocol.getProtocolSubmission().getCommitteeId()) ? StringUtils.equals((CharSequence)this.submissionStatusCode, (CharSequence)"102") || StringUtils.equals((CharSequence)this.submissionStatusCode, (CharSequence)"103") || StringUtils.equals((CharSequence)this.submissionStatusCode, (CharSequence)"206") : StringUtils.equals((CharSequence)this.submissionStatusCode, (CharSequence)"101");
        return retVal;
    }

    @Override
    protected Class<? extends CommitteeScheduleMinuteBase> getCommitteeScheduleMinuteBOClassHook() {
        return IacucCommitteeScheduleMinute.class;
    }

    static {
        HashMap codeMap = new HashMap();
        ACTION_TYPE_SUBMISSION_TYPE_MAP = Collections.unmodifiableMap(codeMap);
    }
}

