/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.notification;

import java.util.List;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.notification.impl.NotificationContextBase;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.notification.impl.exception.UnknownRoleException;
import org.kuali.coeus.common.notification.impl.service.KcNotificationModuleRoleService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRoleQualifierService;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.springframework.util.CollectionUtils;

public abstract class ProtocolNotificationContextBase
extends NotificationContextBase {
    private static final long serialVersionUID = 6642334312368480034L;
    private String documentNumber;
    private String actionTypeCode;
    private String contextName;
    private List<EmailAttachment> emailAttachments;
    private String forwardName;
    private boolean populateRole;

    public ProtocolNotificationContextBase(ProtocolBase protocol, ProtocolOnlineReviewBase protocolOnlineReview, String actionTypeCode, String contextName, NotificationRenderer renderer) {
        this(protocol, actionTypeCode, contextName, renderer);
        ((ProtocolNotificationRoleQualifierService)this.getNotificationRoleQualifierService()).setProtocolOnlineReview(protocolOnlineReview);
    }

    public ProtocolNotificationContextBase(ProtocolBase protocol, String actionTypeCode, String contextName, NotificationRenderer renderer) {
        super(renderer);
        this.documentNumber = protocol.getProtocolDocument().getDocumentNumber();
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.setNotificationModuleRoleService(KcServiceLocator.getService(KcNotificationModuleRoleService.class));
    }

    @Override
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    @Override
    public List<EmailAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    public void setEmailAttachments(List<EmailAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }

    public String getForwardName() {
        return this.forwardName;
    }

    public void setForwardName(String forwardName) {
        this.forwardName = forwardName;
    }

    public boolean isPopulateRole() {
        return this.populateRole;
    }

    public void setPopulateRole(boolean populateRole) {
        this.populateRole = populateRole;
    }

    @Override
    public void populateRoleQualifiers(NotificationTypeRecipient notificationRecipient) throws UnknownRoleException {
        if (!this.isPopulateRole() || CollectionUtils.isEmpty(notificationRecipient.getRoleQualifiers())) {
            super.populateRoleQualifiers(notificationRecipient);
        }
    }
}

