/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.notification;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.notification.impl.NotificationRendererBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolReplacementParameters;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolNotificationRendererBase
extends NotificationRendererBase {
    private static final long serialVersionUID = 7966684994606021231L;
    private static final String D_MMM_YYYY = "d'-'MMM'-'yyyy";
    private static final String COMMITTEE_ID = "committeeId";
    private ProtocolBase protocol;
    private transient BusinessObjectService businessObjectService;
    private transient KcPersonService kcPersonService;

    public ProtocolNotificationRendererBase(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        String[] replacementParameters = ProtocolReplacementParameters.REPLACEMENT_PARAMETERS;
        Map<String, String> params = super.getDefaultReplacementParameters();
        for (String key : replacementParameters) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_NUMBER}")) {
                params.put(key, this.protocol.getProtocolNumber());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PI_NAME}")) {
                params.put(key, this.protocol.getPrincipalInvestigator().getFullName());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LEAD_UNIT}")) {
                params.put(key, this.protocol.getLeadUnitNumber());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LEAD_UNIT_NAME}")) {
                params.put(key, this.protocol.getLeadUnitName());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_STATUS_CODE}")) {
                params.put(key, this.protocol.getProtocolStatusCode());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_STATUS_DESCRIPTION}")) {
                params.put(key, this.protocol.getProtocolStatus().getDescription());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LAST_SUBMISSION_TYPE_CODE}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.protocol.getProtocolSubmission().getSubmissionTypeCode());
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{LAST_SUBMISSION_TYPE_QUAL_CODE}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.protocol.getProtocolSubmission().getSubmissionTypeQualifierCode());
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_TITLE}")) {
                params.put(key, this.protocol.getTitle());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_TYPE_CODE}")) {
                params.put(key, this.protocol.getProtocolTypeCode());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_TYPE_DESCRIPTION}")) {
                if (this.protocol.getProtocolType() != null) {
                    params.put(key, this.protocol.getProtocolType().getDescription());
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{SEQUENCE_NUMBER}")) {
                params.put(key, this.protocol.getSequenceNumber().toString());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{SUBMISSION_STATUS_CODE}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.protocol.getProtocolSubmission().getSubmissionStatusCode());
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{SUBMISSION_STATUS_NAME}")) {
                params.put(key, this.protocol.getProtocolSubmissionStatus());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{USER_FULLNAME}")) {
                params.put(key, GlobalVariables.getUserSession().getPerson().getName());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{DOCUMENT_NUMBER}")) {
                params.put(key, this.protocol.getProtocolDocument().getDocumentNumber());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{COMMITTEE_NAME}")) {
                if (this.protocol.getProtocolSubmission() != null) {
                    params.put(key, this.getSafeMessage(key, this.getCommitteeName(this.protocol.getProtocolSubmission().getCommitteeId())));
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_INITIAL_APPROVAL_DATE}")) {
                if (this.protocol.getProtocolSubmission() != null && this.protocol.getApprovalDate() != null) {
                    params.put(key, this.getSafeMessage(key, new SimpleDateFormat(D_MMM_YYYY).format(this.protocol.getApprovalDate())));
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_LAST_APPROVAL_DATE}")) {
                if (this.protocol.getProtocolSubmission() != null && this.protocol.getLastApprovalDate() != null) {
                    params.put(key, this.getSafeMessage(key, new SimpleDateFormat(D_MMM_YYYY).format(this.protocol.getLastApprovalDate())));
                    continue;
                }
                params.put(key, "");
                continue;
            }
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"{PROTOCOL_EXPIRATION_DATE}")) continue;
            if (this.protocol.getProtocolSubmission() != null && this.protocol.getExpirationDate() != null) {
                params.put(key, this.getSafeMessage(key, new SimpleDateFormat(D_MMM_YYYY).format(this.protocol.getExpirationDate())));
                continue;
            }
            params.put(key, "");
        }
        return params;
    }

    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KNSServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    @Override
    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    private String getCommitteeName(String committeeId) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(COMMITTEE_ID, committeeId);
        List committees = (List)this.getBusinessObjectService().findMatching(this.getCommonCommitteeBOClassHook(), fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)committees)) {
            result = ((CommitteeBase)committees.get(0)).getCommitteeName();
        }
        return result;
    }

    protected abstract Class<? extends CommitteeBase> getCommonCommitteeBOClassHook();
}

