/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.nui.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.framework.keyvalue.KeyValueComparator;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.nui.web.struts.form.NuiAjaxForm;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kns.web.struts.action.KualiDocumentActionBase;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class NuiAjaxAction
extends KualiDocumentActionBase {
    private transient IdentityService identityService;
    private transient DataObjectService dataObjectService;
    private transient UnitService unitService;

    private IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KcServiceLocator.getService(IdentityService.class);
        }
        return this.identityService;
    }

    public ActionForward findPersons(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NuiAjaxForm ajaxForm = (NuiAjaxForm)form;
        String partialName = ajaxForm.getCode();
        if (partialName.contains(",")) {
            partialName = partialName.substring(0, partialName.indexOf(","));
        }
        QueryByCriteria.Builder.create().setOrderByAscending(new String[]{"names.lastName", "names.firstName", "names.middleName"});
        QueryByCriteria qbc = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.likeIgnoreCase((String)"names.lastName", (CharSequence)(partialName + "%"))});
        List entities = this.getIdentityService().findEntities(qbc).getResults();
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        for (Entity value : entities) {
            for (Principal principal : value.getPrincipals()) {
                if (!principal.isActive()) continue;
                result.add((KeyValue)new ConcreteKeyValue(principal.getPrincipalId(), value.getDefaultName().getCompositeNameUnmasked()));
            }
        }
        result.sort(new KeyValueComparator());
        ajaxForm.setReturnVal(this.getJSONforKeyVals(result));
        return mapping.findForward("basic");
    }

    public ActionForward findPersonsKey(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NuiAjaxForm ajaxForm = (NuiAjaxForm)form;
        String personId = ajaxForm.getCode();
        Entity entity = this.getIdentityService().getEntityByPrincipalId(personId);
        String searchKey = entity.getDefaultName().getCompositeNameUnmasked().substring(0, 3);
        ajaxForm.setReturnVal(this.getJSONforSearchKey(searchKey));
        return mapping.findForward("basic");
    }

    public ActionForward findUnits(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NuiAjaxForm ajaxForm = (NuiAjaxForm)form;
        String partialName = ajaxForm.getCode().toUpperCase();
        Collection<Unit> units = this.getUnitService().getUnits();
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        for (Unit unit : units) {
            if (!unit.isActive() || !unit.getUnitName().toUpperCase().contains(partialName) && !unit.getUnitNumber().toUpperCase().contains(partialName)) continue;
            ConcreteKeyValue pair = new ConcreteKeyValue();
            pair.setKey(unit.getUnitNumber());
            pair.setValue(unit.getUnitName() + " (" + unit.getUnitNumber() + ")");
            result.add((KeyValue)pair);
        }
        result.sort(new KeyValueComparator());
        ajaxForm.setReturnVal(this.getJSONforKeyVals(result));
        return mapping.findForward("basic");
    }

    public ActionForward findUnitsKey(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NuiAjaxForm ajaxForm = (NuiAjaxForm)form;
        String unitNumber = ajaxForm.getCode();
        Unit unit = this.getUnitService().getUnit(unitNumber);
        String searchKey = unit.getUnitName().substring(0, 3);
        ajaxForm.setReturnVal(this.getJSONforSearchKey(searchKey));
        return mapping.findForward("basic");
    }

    protected String getJSONforSearchKey(String searchKey) {
        return "{\"searchKey\" : \"" + searchKey + "\"}";
    }

    protected String getJSONforKeyVals(List<KeyValue> result) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ ");
        int index = 0;
        for (KeyValue kv : result) {
            if (index > 0) {
                buffer.append(" , ");
            }
            buffer.append("{ \"label\" :\"");
            buffer.append(kv.getValue());
            buffer.append("\", \"value\" : \"");
            buffer.append(kv.getKey());
            buffer.append("\"}");
            ++index;
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KRADServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    protected UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }
}

