/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.element.BreadcrumbItem;
import org.kuali.rice.krad.uif.element.BreadcrumbOptions;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="pageBreadcrumbOptions", parent="Uif-PageBreadcrumbOptions")
public class PageBreadcrumbOptions
extends BreadcrumbOptions {
    private static final long serialVersionUID = -5666730356781875858L;
    private boolean renderViewBreadcrumb;
    private boolean renderHomewardPathBreadcrumbs;
    private boolean renderPreViewBreadcrumbs;
    private boolean renderPrePageBreadcrumbs;
    private boolean renderParentLocations;

    @Override
    public void setupBreadcrumbs(Object model) {
        View view = ViewLifecycle.getView();
        BreadcrumbOptions viewBreadcrumbOptions = view.getBreadcrumbOptions();
        if (this.getHomewardPathBreadcrumbs() == null && viewBreadcrumbOptions != null && viewBreadcrumbOptions.getHomewardPathBreadcrumbs() != null) {
            this.setHomewardPathBreadcrumbs(viewBreadcrumbOptions.getHomewardPathBreadcrumbs());
        }
        if (this.getPrePageBreadcrumbs() == null && viewBreadcrumbOptions != null && viewBreadcrumbOptions.getPrePageBreadcrumbs() != null) {
            this.setPrePageBreadcrumbs(viewBreadcrumbOptions.getPrePageBreadcrumbs());
        }
        if (this.getPreViewBreadcrumbs() == null && viewBreadcrumbOptions != null && viewBreadcrumbOptions.getPreViewBreadcrumbs() != null) {
            this.setPreViewBreadcrumbs(viewBreadcrumbOptions.getPreViewBreadcrumbs());
        }
        if (this.getBreadcrumbOverrides() == null && viewBreadcrumbOptions != null && viewBreadcrumbOptions.getBreadcrumbOverrides() != null) {
            this.setBreadcrumbOverrides(viewBreadcrumbOptions.getBreadcrumbOverrides());
        }
    }

    @Override
    public void finalizeBreadcrumbs(Object model, Container parent, BreadcrumbItem breadcrumbItem) {
        if (StringUtils.isBlank((String)breadcrumbItem.getLabel()) && parent.getHeader() != null && StringUtils.isNotBlank((String)parent.getHeader().getHeaderText())) {
            breadcrumbItem.setLabel(parent.getHeader().getHeaderText());
        }
        if (StringUtils.isBlank((String)breadcrumbItem.getLabel())) {
            breadcrumbItem.setRender(false);
        }
        this.finalizeBreadcrumbsUrl(model, parent, breadcrumbItem);
        if (breadcrumbItem.getUrl().getPageId() == null) {
            breadcrumbItem.getUrl().setPageId(parent.getId());
        }
    }

    @BeanTagAttribute(name="renderViewBreadcrumb")
    public boolean isRenderViewBreadcrumb() {
        return this.renderViewBreadcrumb;
    }

    public void setRenderViewBreadcrumb(boolean renderViewBreadcrumb) {
        this.renderViewBreadcrumb = renderViewBreadcrumb;
    }

    @BeanTagAttribute(name="renderHomewardPathBreadcrumbs")
    public boolean isRenderHomewardPathBreadcrumbs() {
        return this.renderHomewardPathBreadcrumbs;
    }

    public void setRenderHomewardPathBreadcrumbs(boolean renderHomewardPathBreadcrumbs) {
        this.renderHomewardPathBreadcrumbs = renderHomewardPathBreadcrumbs;
    }

    @BeanTagAttribute(name="renderPreViewBreadcrumbs")
    public boolean isRenderPreViewBreadcrumbs() {
        return this.renderPreViewBreadcrumbs;
    }

    public void setRenderPreViewBreadcrumbs(boolean renderPreViewBreadcrumbs) {
        this.renderPreViewBreadcrumbs = renderPreViewBreadcrumbs;
    }

    @BeanTagAttribute(name="renderPrePageBreadcrumbs")
    public boolean isRenderPrePageBreadcrumbs() {
        return this.renderPrePageBreadcrumbs;
    }

    public void setRenderPrePageBreadcrumbs(boolean renderPrePageBreadcrumbs) {
        this.renderPrePageBreadcrumbs = renderPrePageBreadcrumbs;
    }

    @BeanTagAttribute(name="renderParentLocations")
    public boolean isRenderParentLocations() {
        return this.renderParentLocations;
    }

    public void setRenderParentLocations(boolean renderParentLocations) {
        this.renderParentLocations = renderParentLocations;
    }
}

