/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextValidTermBo;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;

public class TermSpecificationMaintainable
extends MaintainableImpl {
    private static final long serialVersionUID = 1L;

    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        TermSpecificationBo termSpecificationBo = (TermSpecificationBo)super.retrieveObjectForEditOrCopy(document, dataObjectKeys);
        if ("Copy".equals(this.getMaintenanceAction())) {
            document.getDocumentHeader().setDocumentDescription("New Term Specification Document");
        }
        return termSpecificationBo;
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterNew(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("New Term Specification Document");
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterEdit(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("Edited Term Specification Document");
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterCopy(document, requestParameters);
        this.copyContextsOldToNewBo(document);
        this.setNewContextValidTermsNewBO(document);
    }

    private void copyContextsOldToNewBo(MaintenanceDocument document) {
        TermSpecificationBo newTermSpec = (TermSpecificationBo)document.getNewMaintainableObject().getDataObject();
        newTermSpec.getContexts().clear();
        newTermSpec.getContexts();
    }

    private void setNewContextValidTermsNewBO(MaintenanceDocument document) {
        TermSpecificationBo newTermSpec = (TermSpecificationBo)document.getNewMaintainableObject().getDataObject();
        for (ContextValidTermBo contextValidTermBo : newTermSpec.getContextValidTerms()) {
            contextValidTermBo.setId(null);
            contextValidTermBo.setTermSpecification(newTermSpec);
        }
    }

    public void prepareForSave() {
        super.prepareForSave();
        TermSpecificationBo termSpec = (TermSpecificationBo)this.getDataObject();
        termSpec.getContexts().clear();
    }

    public void processAfterAddLine(ViewModel viewModel, Object addLine, String collectionId, String collectionPath, boolean isValidLine) {
        if (addLine == null || !(addLine instanceof ContextBo)) {
            super.processAfterAddLine(viewModel, addLine, collectionId, collectionPath, isValidLine);
            return;
        }
        ContextBo addedContext = (ContextBo)addLine;
        TermSpecificationBo termSpec = (TermSpecificationBo)TermSpecificationMaintainable.getDataObjectFromForm(viewModel);
        boolean alreadyHasContextValidTerm = false;
        for (ContextValidTermBo contextValidTerm : termSpec.getContextValidTerms()) {
            if (!contextValidTerm.getContextId().equals(addedContext.getId())) continue;
            alreadyHasContextValidTerm = true;
            break;
        }
        if (!alreadyHasContextValidTerm) {
            ContextValidTermBo contextValidTerm = new ContextValidTermBo();
            contextValidTerm.setContextId(addedContext.getId());
            contextValidTerm.setTermSpecification(termSpec);
            termSpec.getContextValidTerms().add(contextValidTerm);
        }
    }

    public void processCollectionDeleteLine(ViewModel viewModel, String collectionId, String collectionPath, int lineIndex) {
        List collection = (List)ObjectPropertyUtils.getPropertyValue((Object)viewModel, (String)collectionPath);
        Object deletedItem = collection.get(lineIndex);
        if (deletedItem == null || !(deletedItem instanceof ContextBo)) {
            super.processCollectionDeleteLine(viewModel, collectionId, collectionPath, lineIndex);
            return;
        }
        ContextBo context = (ContextBo)deletedItem;
        TermSpecificationBo termSpec = (TermSpecificationBo)TermSpecificationMaintainable.getDataObjectFromForm(viewModel);
        ListIterator<ContextValidTermBo> contextValidTermListIter = termSpec.getContextValidTerms().listIterator();
        while (contextValidTermListIter.hasNext()) {
            ContextValidTermBo contextValidTerm = contextValidTermListIter.next();
            if (!contextValidTerm.getContextId().equals(context.getId())) continue;
            contextValidTerm.setTermSpecification(null);
            contextValidTermListIter.remove();
            termSpec.getContexts().remove(context);
        }
    }

    private static <T> T getDataObjectFromForm(ViewModel form) {
        if (form == null) {
            return null;
        }
        return (T)((MaintenanceDocumentForm)form).getDocument().getNewMaintainableObject().getDataObject();
    }

    public Class getDataObjectClass() {
        return TermSpecificationBo.class;
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
    }
}

