/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.util.cache.CopiedObject;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.AttachmentService;
import org.kuali.rice.krad.service.NoteService;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class NoteServiceImpl
implements NoteService {
    protected AttachmentService attachmentService;
    protected DataObjectService dataObjectService;

    public void saveNoteList(List<Note> notes) {
        if (notes != null) {
            for (Note note : notes) {
                if (StringUtils.isBlank((String)note.getRemoteObjectIdentifier())) {
                    throw new IllegalStateException("The remote object identifier must be established on a Note before it can be saved.  The following note in the given list had a null or empty remote object identifier: " + note);
                }
                this.save(note);
            }
        }
    }

    public Note save(Note note) {
        this.validateNoteNotNull(note);
        if (StringUtils.isBlank((String)note.getRemoteObjectIdentifier())) {
            throw new IllegalStateException("The remote object identifier must be established on a Note before it can be saved.  Given note had a null or empty remote object identifier.");
        }
        if (note.getAttachment() != null && note.getAttachment().getAttachmentFileName() == null) {
            note.setAttachment(null);
        }
        if (note != null && note.getNoteIdentifier() == null && note.getAttachment() != null) {
            Attachment attachment = note.getAttachment();
            note.setAttachment(null);
            note = (Note)this.dataObjectService.save((Object)note, new PersistenceOption[0]);
            attachment.setNoteIdentifier(note.getNoteIdentifier());
            note.setAttachment(attachment);
        }
        if ((note = (Note)this.dataObjectService.save((Object)note, new PersistenceOption[0])).getAttachment() != null) {
            this.attachmentService.moveAttachmentWherePending(note);
        }
        return note;
    }

    public List<Note> getByRemoteObjectId(String remoteObjectId) {
        if (StringUtils.isBlank((String)remoteObjectId)) {
            throw new IllegalArgumentException("The remoteObjectId must not be null or blank.");
        }
        QueryResults result = this.dataObjectService.findMatching(Note.class, QueryByCriteria.Builder.forAttribute((String)"remoteObjectIdentifier", (Object)remoteObjectId).setOrderByFields(new OrderByField[]{OrderByField.Builder.create((String)"notePostedTimestamp", (OrderDirection)OrderDirection.ASCENDING).build()}).build());
        return result.getResults();
    }

    public Note getNoteByNoteId(Long noteId) {
        if (noteId == null) {
            throw new IllegalArgumentException("The noteId must not be null.");
        }
        return (Note)this.dataObjectService.find(Note.class, (Object)noteId);
    }

    public void deleteNote(Note note) {
        this.validateNoteNotNull(note);
        if (note.getAttachment() != null) {
            this.dataObjectService.delete((Object)note.getAttachment());
            note.setAttachment(null);
        }
        this.dataObjectService.delete((Object)note);
    }

    public Note createNote(Note noteToCopy, GloballyUnique bo, String authorPrincipalId) {
        this.validateNoteNotNull(noteToCopy);
        if (bo == null) {
            throw new IllegalArgumentException("The bo must not be null.");
        }
        if (StringUtils.isBlank((String)authorPrincipalId)) {
            throw new IllegalArgumentException("The authorPrincipalId must not be null.");
        }
        Note tmpNote = (Note)new CopiedObject((Serializable)noteToCopy).getContent();
        tmpNote.setRemoteObjectIdentifier(bo.getObjectId());
        tmpNote.setAuthorUniversalIdentifier(authorPrincipalId);
        return tmpNote;
    }

    @Required
    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    protected AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    private void validateNoteNotNull(Note note) {
        if (note == null) {
            throw new IllegalArgumentException("Note must not be null.");
        }
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

