/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.meeting;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.document.authorization.CommitteeScheduleTaskBase;
import org.kuali.coeus.common.committee.impl.document.authorization.CommitteeTaskBase;
import org.kuali.coeus.common.committee.impl.meeting.CommScheduleActItemBase;
import org.kuali.coeus.common.committee.impl.meeting.CommScheduleMinuteDocBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleAttachmentsBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.committee.impl.meeting.MeetingFormBase;
import org.kuali.coeus.common.committee.impl.meeting.MemberAbsentBean;
import org.kuali.coeus.common.committee.impl.meeting.MemberPresentBean;
import org.kuali.coeus.common.committee.impl.meeting.OtherPresentBeanBase;
import org.kuali.coeus.common.committee.impl.meeting.ProtocolSubmittedBean;
import org.kuali.coeus.common.committee.impl.meeting.ScheduleAgendaBase;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.actions.print.CorrespondencePrintOption;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class MeetingHelperBase
implements Serializable {
    private static final long serialVersionUID = 2363534404324211441L;
    private static final String FIELD_SEPARAATOR = "#f#";
    private MeetingFormBase form;
    private Date agendaGenerationDate;
    private CommitteeScheduleBase<?, ?, ?, ?> committeeSchedule;
    private List<ProtocolSubmittedBean> protocolSubmittedBeans;
    private CommScheduleActItemBase newOtherAction;
    private List<CommScheduleActItemBase> deletedOtherActions;
    private List<CommitteeScheduleAttendanceBase> deletedAttendances;
    private String tabLabel;
    private List<MemberPresentBean> memberPresentBeans;
    private List<MemberAbsentBean> memberAbsentBeans;
    private List<OtherPresentBeanBase> otherPresentBeans;
    private OtherPresentBeanBase newOtherPresentBean;
    private String absenteeList;
    private CommitteeScheduleMinuteBase<?, ?> newCommitteeScheduleMinute;
    private List<CommitteeScheduleMinuteBase<?, ?>> deletedCommitteeScheduleMinutes;
    private boolean jsDisabled = false;
    private boolean modifySchedule = false;
    private boolean viewSchedule = false;
    private List<ScheduleAgendaBase> scheduleAgendas;
    private List<CommScheduleMinuteDocBase> minuteDocs;
    private List<ProtocolCorrespondence> correspondences;
    private String reportType;
    private String viewId;
    private Boolean printRooster;
    private Boolean printFutureScheduledMeeting;
    private boolean hideReviewerName;
    private static String minutesSentMessage;
    private static String agendaSentMessage;
    private ProtocolCorrespondence protocolCorrespondence;
    private List<ProtocolCorrespondence> regeneratedCorrespondences;
    private List<CorrespondencePrintOption> correspondencesToPrint;
    private CommitteeScheduleAttachmentsBase newCommitteeScheduleAttachments;
    private static final String MESSAGE_COMMITTEESCHEDULE_AGENDASENT = "message.committeeSchedule.agendaSent";
    private static final String MESSAGE_COMMITTEESCHEDULE_MINUTESSENT = "message.committeeSchedule.minutesSent";
    private transient SystemAuthorizationService systemAuthorizationService;

    public MeetingHelperBase(MeetingFormBase form) {
        this.form = form;
        this.committeeSchedule = this.getNewCommitteeScheduleInstanceHook();
        this.protocolSubmittedBeans = new ArrayList<ProtocolSubmittedBean>();
        this.memberPresentBeans = new ArrayList<MemberPresentBean>();
        this.memberAbsentBeans = new ArrayList<MemberAbsentBean>();
        this.otherPresentBeans = new ArrayList<OtherPresentBeanBase>();
        this.newOtherAction = this.getNewCommScheduleActItemInstanceHook();
        this.newCommitteeScheduleMinute = this.getNewCommitteeScheduleMinuteInstanceHook();
        this.newCommitteeScheduleAttachments = this.getNewCommitteeScheduleAttachmentsInstanceHook();
        this.newOtherPresentBean = this.getNewOtherPresentBeanInstanceHook();
        this.scheduleAgendas = new ArrayList<ScheduleAgendaBase>();
        this.minuteDocs = new ArrayList<CommScheduleMinuteDocBase>();
        this.correspondences = new ArrayList<ProtocolCorrespondence>();
        this.printRooster = new Boolean(false);
        this.printFutureScheduledMeeting = new Boolean(false);
        this.initDeletedList();
        this.initPrintCorrespondence();
    }

    protected abstract CommitteeScheduleAttachmentsBase getNewCommitteeScheduleAttachmentsInstanceHook();

    protected abstract OtherPresentBeanBase getNewOtherPresentBeanInstanceHook();

    protected abstract CommScheduleActItemBase getNewCommScheduleActItemInstanceHook();

    protected abstract CommitteeScheduleMinuteBase<?, ?> getNewCommitteeScheduleMinuteInstanceHook();

    protected abstract CommitteeScheduleBase<?, ?, ?, ?> getNewCommitteeScheduleInstanceHook();

    public MeetingFormBase getForm() {
        return this.form;
    }

    public void setForm(MeetingFormBase form) {
        this.form = form;
    }

    public CommScheduleActItemBase getNewOtherAction() {
        return this.newOtherAction;
    }

    public void setNewOtherAction(CommScheduleActItemBase newOtherAction) {
        this.newOtherAction = newOtherAction;
    }

    public String getTabLabel() {
        return this.tabLabel;
    }

    public void setTabLabel(String tabLabel) {
        this.tabLabel = tabLabel;
    }

    public CommitteeScheduleBase<?, ?, ?, ?> getCommitteeSchedule() {
        return this.committeeSchedule;
    }

    public void setCommitteeSchedule(CommitteeScheduleBase<?, ?, ?, ?> committeeSchedule) {
        this.committeeSchedule = committeeSchedule;
    }

    public Date getAgendaGenerationDate() {
        return this.agendaGenerationDate;
    }

    public void setAgendaGenerationDate(Date agendaGenerationDate) {
        this.agendaGenerationDate = agendaGenerationDate;
    }

    public List<CommScheduleActItemBase> getDeletedOtherActions() {
        return this.deletedOtherActions;
    }

    public void setDeletedOtherActions(List<CommScheduleActItemBase> deletedOtherActions) {
        this.deletedOtherActions = deletedOtherActions;
    }

    public List<ProtocolSubmittedBean> getProtocolSubmittedBeans() {
        return this.protocolSubmittedBeans;
    }

    public void setProtocolSubmittedBeans(List<ProtocolSubmittedBean> protocolSubmittedBeans) {
        this.protocolSubmittedBeans = protocolSubmittedBeans;
    }

    public List<MemberPresentBean> getMemberPresentBeans() {
        return this.memberPresentBeans;
    }

    public void setMemberPresentBeans(List<MemberPresentBean> memberPresentBeans) {
        this.memberPresentBeans = memberPresentBeans;
    }

    public List<MemberAbsentBean> getMemberAbsentBeans() {
        return this.memberAbsentBeans;
    }

    public void setMemberAbsentBeans(List<MemberAbsentBean> memberAbsentBeans) {
        this.memberAbsentBeans = memberAbsentBeans;
    }

    public List<OtherPresentBeanBase> getOtherPresentBeans() {
        return this.otherPresentBeans;
    }

    public void setOtherPresentBeans(List<OtherPresentBeanBase> otherPresentBeans) {
        this.otherPresentBeans = otherPresentBeans;
    }

    public OtherPresentBeanBase getNewOtherPresentBean() {
        return this.newOtherPresentBean;
    }

    public void setNewOtherPresentBean(OtherPresentBeanBase newOtherPresentBean) {
        this.newOtherPresentBean = newOtherPresentBean;
    }

    public String getAbsenteeList() {
        if (StringUtils.isBlank((CharSequence)this.absenteeList) && !this.memberAbsentBeans.isEmpty()) {
            this.absenteeList = this.initAbsenteeList();
        }
        return this.absenteeList;
    }

    public void setAbsenteeList(String absenteeList) {
        this.absenteeList = absenteeList;
    }

    private String initAbsenteeList() {
        Object result = "";
        for (MemberAbsentBean memberAbsentBean : this.memberAbsentBeans) {
            if (StringUtils.isBlank((CharSequence)result)) {
                result = memberAbsentBean.getAttendance().getPersonId() + FIELD_SEPARAATOR + memberAbsentBean.getAttendance().getPersonName();
                continue;
            }
            result = (String)result + "#m#" + memberAbsentBean.getAttendance().getPersonId() + FIELD_SEPARAATOR + memberAbsentBean.getAttendance().getPersonName();
        }
        return result;
    }

    public List<CommitteeScheduleAttendanceBase> getDeletedAttendances() {
        return this.deletedAttendances;
    }

    public void setDeletedAttendances(List<CommitteeScheduleAttendanceBase> deletedAttendances) {
        this.deletedAttendances = deletedAttendances;
    }

    public CommitteeScheduleMinuteBase getNewCommitteeScheduleMinute() {
        return this.newCommitteeScheduleMinute;
    }

    public void setNewCommitteeScheduleMinute(CommitteeScheduleMinuteBase<?, ?> newCommitteeScheduleMinute) {
        this.newCommitteeScheduleMinute = newCommitteeScheduleMinute;
    }

    public List<CommitteeScheduleMinuteBase<?, ?>> getDeletedCommitteeScheduleMinutes() {
        return this.deletedCommitteeScheduleMinutes;
    }

    public CommitteeScheduleAttachmentsBase getNewCommitteeScheduleAttachments() {
        return this.newCommitteeScheduleAttachments;
    }

    public void setNewCommitteeScheduleAttachments(CommitteeScheduleAttachmentsBase newCommitteeScheduleAttachments) {
        this.newCommitteeScheduleAttachments = newCommitteeScheduleAttachments;
    }

    public void setDeletedCommitteeScheduleMinutes(List<CommitteeScheduleMinuteBase<?, ?>> deletedCommitteeScheduleMinutes) {
        this.deletedCommitteeScheduleMinutes = deletedCommitteeScheduleMinutes;
    }

    protected void initDeletedList() {
        this.setDeletedOtherActions(new ArrayList<CommScheduleActItemBase>());
        this.setDeletedCommitteeScheduleMinutes(new ArrayList());
        this.setDeletedAttendances(new ArrayList<CommitteeScheduleAttendanceBase>());
    }

    protected List<PersistableBusinessObject> getDeletedBos() {
        ArrayList<PersistableBusinessObject> deletedBos = new ArrayList<PersistableBusinessObject>();
        deletedBos.addAll(this.form.getMeetingHelper().getDeletedOtherActions());
        deletedBos.addAll(this.form.getMeetingHelper().getDeletedAttendances());
        deletedBos.addAll(this.form.getMeetingHelper().getDeletedCommitteeScheduleMinutes());
        return deletedBos;
    }

    protected void populateAttendancePreSave() {
        ArrayList<CommitteeScheduleAttendanceBase> attendances = new ArrayList<CommitteeScheduleAttendanceBase>();
        for (MemberPresentBean memberPresentBean : this.getMemberPresentBeans()) {
            memberPresentBean.getAttendance().setGuestFlag(false);
            attendances.add(memberPresentBean.getAttendance());
        }
        for (OtherPresentBeanBase otherPresentBean : this.getOtherPresentBeans()) {
            otherPresentBean.getAttendance().setGuestFlag(true);
            attendances.add(otherPresentBean.getAttendance());
        }
        this.setDeletedAttendances(this.committeeSchedule.getCommitteeScheduleAttendances());
        this.committeeSchedule.setCommitteeScheduleAttendances(attendances);
    }

    protected void sortAttendances() {
        if (!this.getMemberPresentBeans().isEmpty()) {
            Collections.sort(this.getMemberPresentBeans());
        }
        if (!this.getMemberAbsentBeans().isEmpty()) {
            Collections.sort(this.getMemberAbsentBeans());
        }
        if (!this.getOtherPresentBeans().isEmpty()) {
            Collections.sort(this.getOtherPresentBeans());
        }
    }

    public boolean isJsDisabled() {
        return this.jsDisabled;
    }

    public void setJsDisabled(boolean jsDisabled) {
        this.jsDisabled = jsDisabled;
    }

    public boolean hasViewModifySchedulePermission() {
        return this.canModifySchedule() || this.canViewSchedule() && this.form.isReadOnly();
    }

    public boolean canModifySchedule() {
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("modifySchedule", (CommitteeBase)this.committeeSchedule.getParentCommittee());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    public boolean getCanModifySchedule() {
        return this.canModifySchedule();
    }

    public boolean canViewSchedule() {
        CommitteeScheduleTaskBase task = this.getNewCommitteeScheduleTaskInstanceHook("viewSchedule", (CommitteeBase)this.committeeSchedule.getParentCommittee(), this.committeeSchedule);
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract CommitteeScheduleTaskBase getNewCommitteeScheduleTaskInstanceHook(String var1, CommitteeBase var2, CommitteeScheduleBase var3);

    public boolean getCanViewSchedule() {
        return this.canViewSchedule();
    }

    public boolean isModifySchedule() {
        return this.modifySchedule;
    }

    public void setModifySchedule(boolean modifySchedule) {
        this.modifySchedule = modifySchedule;
    }

    public boolean isViewSchedule() {
        return this.viewSchedule;
    }

    public void setViewSchedule(boolean viewSchedule) {
        this.viewSchedule = viewSchedule;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KcServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public List<ScheduleAgendaBase> getScheduleAgendas() {
        return this.scheduleAgendas;
    }

    public void setScheduleAgendas(List<ScheduleAgendaBase> scheduleAgendas) {
        this.scheduleAgendas = scheduleAgendas;
    }

    public List<CommScheduleMinuteDocBase> getMinuteDocs() {
        return this.minuteDocs;
    }

    public void setMinuteDocs(List<CommScheduleMinuteDocBase> minuteDocs) {
        this.minuteDocs = minuteDocs;
    }

    public List<ProtocolCorrespondence> getCorrespondences() {
        return this.correspondences;
    }

    public void setCorrespondences(List<ProtocolCorrespondence> correspondences) {
        this.correspondences = correspondences;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public Boolean getPrintRooster() {
        return this.printRooster;
    }

    public void setPrintRooster(Boolean printRooster) {
        this.printRooster = printRooster;
    }

    public Boolean getPrintFutureScheduledMeeting() {
        return this.printFutureScheduledMeeting;
    }

    public void setPrintFutureScheduledMeeting(Boolean printFutureScheduledMeeting) {
        this.printFutureScheduledMeeting = printFutureScheduledMeeting;
    }

    public boolean isHideReviewerName() {
        return this.hideReviewerName;
    }

    public void setHideReviewerName(boolean hideReviewerName) {
        this.hideReviewerName = hideReviewerName;
    }

    public String getMinutesSentMessage() {
        if (minutesSentMessage == null) {
            minutesSentMessage = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString(MESSAGE_COMMITTEESCHEDULE_MINUTESSENT);
        }
        return minutesSentMessage;
    }

    public String getAgendaSentMessage() {
        if (agendaSentMessage == null) {
            agendaSentMessage = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString(MESSAGE_COMMITTEESCHEDULE_AGENDASENT);
        }
        return agendaSentMessage;
    }

    public ProtocolCorrespondence getProtocolCorrespondence() {
        return this.protocolCorrespondence;
    }

    public void setProtocolCorrespondence(ProtocolCorrespondence protocolCorrespondence) {
        this.protocolCorrespondence = protocolCorrespondence;
    }

    public List<ProtocolCorrespondence> getRegeneratedCorrespondences() {
        return this.regeneratedCorrespondences;
    }

    public void setRegeneratedCorrespondences(List<ProtocolCorrespondence> regeneratedCorrespondences) {
        this.regeneratedCorrespondences = regeneratedCorrespondences;
    }

    protected SystemAuthorizationService getSystemAuthorizationService() {
        if (this.systemAuthorizationService == null) {
            this.systemAuthorizationService = KcServiceLocator.getService(SystemAuthorizationService.class);
        }
        return this.systemAuthorizationService;
    }

    public abstract boolean isAdmin();

    public List<CorrespondencePrintOption> getCorrespondencesToPrint() {
        return this.correspondencesToPrint;
    }

    public void setCorrespondencesToPrint(List<CorrespondencePrintOption> correspondencesToPrint) {
        this.correspondencesToPrint = correspondencesToPrint;
    }

    protected abstract void initPrintCorrespondence();
}

