/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.person.signature;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PrintTextLocator
extends PDFTextStripper {
    private static final Writer NO_OP = new Writer(){

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    };
    private final Set<String> searchStrings;
    private Set<PDFTextLocation> locations;

    public PrintTextLocator(PDDocument document, Set<String> searchStrings) throws IOException {
        super.setSortByPosition(true);
        this.document = document;
        this.searchStrings = searchStrings;
        this.output = NO_OP;
    }

    public Set<PDFTextLocation> doSearch() throws IOException {
        this.locations = new HashSet<PDFTextLocation>();
        this.processPages(this.document.getDocumentCatalog().getPages());
        return this.locations;
    }

    protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
        super.writeString(text);
        for (String searchString : this.searchStrings) {
            int start = text.indexOf(searchString);
            if (start == -1) continue;
            TextPosition pos = textPositions.get(start);
            PDFTextLocation textLoc = new PDFTextLocation();
            textLoc.setText(text);
            textLoc.setFound(true);
            textLoc.setPage(this.getCurrentPageNo());
            textLoc.setX(pos.getX());
            textLoc.setY(pos.getY());
            this.locations.add(textLoc);
        }
    }

    public static final class PDFTextLocation {
        private boolean found;
        private String text;
        private int page;
        private float x;
        private float y;

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public int getPage() {
            return this.page;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PDFTextLocation that = (PDFTextLocation)o;
            if (this.found != that.found) {
                return false;
            }
            if (this.page != that.page) {
                return false;
            }
            if (Float.compare(that.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(that.y, this.y) != 0) {
                return false;
            }
            return this.text != null ? this.text.equals(that.text) : that.text == null;
        }

        public int hashCode() {
            int result = this.found ? 1 : 0;
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            result = 31 * result + this.page;
            result = 31 * result + (this.x != 0.0f ? Float.floatToIntBits(this.x) : 0);
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            return result;
        }

        public String toString() {
            return "PDFTextLocation{found=" + this.found + ", text='" + this.text + "', page=" + this.page + ", x=" + this.x + ", y=" + this.y + "}";
        }
    }
}

