/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeService;
import org.kuali.coeus.propdev.impl.attachment.LegacyNarrativeService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeAttachment;
import org.kuali.coeus.propdev.impl.attachment.NarrativeStatus;
import org.kuali.coeus.propdev.impl.attachment.NarrativeType;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="narrativeService")
public class NarrativeServiceImpl
implements NarrativeService {
    public static final int ADDITIONAL_KEYPERSONS_ATTACHMENT = 11;
    public static final int ADDITIONAL_EQUIPMENT_ATTACHMENT = 12;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="legacyNarrativeService")
    private LegacyNarrativeService legacyNarrativeService;

    public void deleteAutoGeneratedNarratives(List<? extends NarrativeContract> narratives) {
        this.deleteIf(narratives, new Predicate(){

            @Override
            public boolean v(NarrativeContract n) {
                return NarrativeServiceImpl.this.isAutoGeneratedNarrative(n);
            }
        });
    }

    public boolean isAutoGeneratedNarrative(NarrativeContract narrative) {
        if (narrative == null) {
            throw new IllegalArgumentException("narrative is null");
        }
        String typeCode = narrative.getNarrativeType().getCode();
        return typeCode != null && (Integer.parseInt(typeCode) == 11 || Integer.parseInt(typeCode) == 12);
    }

    public void deleteSystemGeneratedNarratives(List<? extends NarrativeContract> narratives) {
        this.deleteIf(narratives, new Predicate(){

            @Override
            public boolean v(NarrativeContract n) {
                return NarrativeServiceImpl.this.isSystemGeneratedNarrative(n);
            }
        });
    }

    public void deleteIf(List<? extends NarrativeContract> narratives, Predicate p) {
        if (narratives == null) {
            throw new IllegalArgumentException("narratives is null");
        }
        for (final NarrativeContract narrativeContract : narratives) {
            if (!p.v(narrativeContract)) continue;
            this.dataObjectService.deleteMatching(Narrative.class, QueryByCriteria.Builder.andAttributes((Map)new HashMap<String, Object>(){
                {
                    this.put("developmentProposal.proposalNumber", narrativeContract.getProposalNumber());
                    this.put("moduleNumber", narrativeContract.getModuleNumber());
                }
            }).build());
        }
    }

    public boolean isSystemGeneratedNarrative(NarrativeContract narrative) {
        if (narrative == null) {
            throw new IllegalArgumentException("narrative is null");
        }
        return narrative.getNarrativeType().isSystemGenerated();
    }

    public NarrativeContract createSystemGeneratedNarrative(String proposalNumber, String narrativeTypeCode, byte[] attachmentData, String attachmentName, String comments) {
        if (StringUtils.isBlank((CharSequence)proposalNumber)) {
            throw new IllegalArgumentException("proposalNumber is blank");
        }
        if (StringUtils.isBlank((CharSequence)narrativeTypeCode)) {
            throw new IllegalArgumentException("narrativeTypeCode is blank");
        }
        if (attachmentData == null) {
            throw new IllegalArgumentException("attachmentData is null");
        }
        if (attachmentData.length == 0) {
            throw new IllegalArgumentException("attachmentData.length is 0");
        }
        if (StringUtils.isBlank((CharSequence)attachmentName)) {
            throw new IllegalArgumentException("attachmentName is blank");
        }
        if (StringUtils.isBlank((CharSequence)comments)) {
            throw new IllegalArgumentException("comments is blank");
        }
        DevelopmentProposal developmentProposal = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)proposalNumber);
        NarrativeType narrativeType = new NarrativeType();
        narrativeType.setDescription(comments);
        narrativeType.setSystemGenerated(true);
        narrativeType.setCode(narrativeTypeCode);
        NarrativeAttachment narrativeAttachment = new NarrativeAttachment();
        narrativeAttachment.setType("application/octet-stream");
        narrativeAttachment.setData(attachmentData);
        narrativeAttachment.setName(attachmentName);
        Narrative narrative = new Narrative();
        narrative.setModuleStatusCode("C");
        narrative.setNarrativeStatus((NarrativeStatus)this.getDataObjectService().find(NarrativeStatus.class, (Object)narrative.getModuleStatusCode()));
        narrative.setNarrativeTypeCode(narrativeTypeCode);
        narrative.setComments(comments);
        narrative.setModuleTitle(comments);
        narrative.setName(attachmentName);
        narrative.setNarrativeAttachment(narrativeAttachment);
        narrative.setNarrativeType(narrativeType);
        narrative.setModuleSequenceNumber(this.getLegacyNarrativeService().getNextModuleSequenceNumber(developmentProposal.getProposalDocument()));
        narrative.setModuleNumber(this.getLegacyNarrativeService().getNextModuleNumber(developmentProposal.getProposalDocument()));
        narrative.setDevelopmentProposal(developmentProposal);
        developmentProposal.getNarratives().add(narrative);
        return narrative;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public LegacyNarrativeService getLegacyNarrativeService() {
        return this.legacyNarrativeService;
    }

    public void setLegacyNarrativeService(LegacyNarrativeService legacyNarrativeService) {
        this.legacyNarrativeService = legacyNarrativeService;
    }

    private static interface Predicate {
        public boolean v(NarrativeContract var1);
    }
}

