/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.paymentschedule;

import java.sql.Date;
import java.sql.Timestamp;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardAssociate;
import org.kuali.kra.award.paymentreports.ReportStatus;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;

public class AwardPaymentSchedule
extends AwardAssociate {
    private static final long serialVersionUID = 1387310207139506329L;
    private Long awardPaymentScheduleId;
    private Long awardReportTermId;
    private Date dueDate;
    private ScaleTwoDecimal amount;
    private Date submitDate;
    private String submittedBy;
    private String invoiceNumber;
    private String statusDescription;
    private String status;
    private Integer overdue;
    private String lastUpdateUser;
    private Timestamp lastUpdateTimestamp;
    private String reportStatusCode;
    private String submittedByPersonId;
    private String awardReportTermDescription;
    private AwardReportTerm awardReportTerm;
    private KcPerson submittedByPerson;
    private ReportStatus reportStatus;
    private transient KcPersonService kcPersonService;

    public AwardPaymentSchedule() {
    }

    public AwardPaymentSchedule(Date dueDate, String awardNumber, Integer sequenceNumber) {
        this.setAwardNumber(awardNumber);
        this.setSequenceNumber(sequenceNumber);
        this.dueDate = dueDate;
    }

    public Long getAwardPaymentScheduleId() {
        return this.awardPaymentScheduleId;
    }

    public void setAwardPaymentScheduleId(Long awardPaymentScheduleId) {
        this.awardPaymentScheduleId = awardPaymentScheduleId;
    }

    public Long getAwardReportTermId() {
        return this.awardReportTermId;
    }

    public void setAwardReportTermId(Long awardReportTermId) {
        this.awardReportTermId = awardReportTermId;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public ScaleTwoDecimal getAmount() {
        return this.amount;
    }

    @Override
    public void resetPersistenceState() {
        this.awardPaymentScheduleId = null;
    }

    public void setAmount(ScaleTwoDecimal amount) {
        this.amount = amount;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.getAwardNumber() == null ? 0 : this.getAwardNumber().hashCode());
        result = 31 * result + (this.dueDate == null ? 0 : this.dueDate.hashCode());
        result = 31 * result + (this.getSequenceNumber() == null ? 0 : this.getSequenceNumber().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwardPaymentSchedule)) {
            return false;
        }
        return this.equals((AwardPaymentSchedule)obj);
    }

    public boolean equals(AwardPaymentSchedule awardPaymentSchedule) {
        if (this.getAwardNumber() == null ? awardPaymentSchedule.getAwardNumber() != null : !this.getAwardNumber().equals(awardPaymentSchedule.getAwardNumber())) {
            return false;
        }
        if (this.dueDate == null ? awardPaymentSchedule.dueDate != null : !this.dueDate.equals(awardPaymentSchedule.dueDate)) {
            return false;
        }
        return !(this.getSequenceNumber() == null ? awardPaymentSchedule.getSequenceNumber() != null : !this.getSequenceNumber().equals(awardPaymentSchedule.getSequenceNumber()));
    }

    public boolean checkForUpdates(AwardPaymentSchedule awardPaymentSchedule) {
        boolean retVal = true;
        if (awardPaymentSchedule == null || !this.objectCompare(this.getAwardPaymentScheduleId(), awardPaymentSchedule.getAwardPaymentScheduleId())) {
            throw new IllegalArgumentException("The passed in award payment schedule is null, or it has a different AwardPaymentScheduleId than this object.");
        }
        retVal &= this.objectCompare(this.getInvoiceNumber(), awardPaymentSchedule.getInvoiceNumber());
        retVal &= this.objectCompare(this.getDueDate(), awardPaymentSchedule.getDueDate());
        retVal &= this.objectCompare(this.getOverdue(), awardPaymentSchedule.getOverdue());
        retVal &= this.objectCompare(this.getStatusDescription(), awardPaymentSchedule.getStatusDescription());
        retVal &= this.objectCompare(this.getStatus(), awardPaymentSchedule.getStatus());
        retVal &= this.objectCompare(this.getAmount(), awardPaymentSchedule.getAmount());
        retVal &= this.objectCompare(this.getSubmittedBy(), awardPaymentSchedule.getSubmittedBy());
        return !(retVal &= this.objectCompare(this.getSubmitDate(), awardPaymentSchedule.getSubmitDate()));
    }

    private boolean objectCompare(Object ob1, Object ob2) {
        boolean retVal = false;
        if (ob1 == null && ob2 == null) {
            retVal = true;
        } else if (ob1 != null && ob2 != null && ob1.equals(ob2)) {
            retVal = true;
        }
        return retVal;
    }

    public Integer getOverdue() {
        return this.overdue;
    }

    public void setOverdue(Integer overdue) {
        this.overdue = overdue;
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public Timestamp getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public void setLastUpdateTimestamp(Timestamp lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    public String getReportStatusCode() {
        return this.reportStatusCode;
    }

    public void setReportStatusCode(String reportStatusCode) {
        this.reportStatusCode = reportStatusCode;
    }

    public String getSubmittedByPersonId() {
        return this.submittedByPersonId;
    }

    public void setSubmittedByPersonId(String submittedByPersonId) {
        this.submittedByPersonId = submittedByPersonId;
    }

    public KcPerson getSubmittedByPerson() {
        if (this.submittedByPerson == null && this.getSubmittedByPersonId() != null) {
            this.submittedByPerson = this.getKcPersonService().getKcPersonByPersonId(this.getSubmittedByPersonId());
        }
        return this.submittedByPerson;
    }

    public String getSubmittedByPersonUsername() {
        KcPerson submitter = this.getSubmittedByPerson();
        return submitter == null ? "" : submitter.getUserName();
    }

    public String getSubmittedByPersonFullname() {
        KcPerson submitter = this.getSubmittedByPerson();
        return submitter == null ? "" : submitter.getFullName();
    }

    public ReportStatus getReportStatus() {
        return this.reportStatus;
    }

    public void setReportStatus(ReportStatus reportStatus) {
        this.reportStatus = reportStatus;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public String getAwardReportTermDescription() {
        return this.awardReportTermDescription;
    }

    public void setAwardReportTermDescription(String awardReportTermDescription) {
        this.awardReportTermDescription = awardReportTermDescription;
    }

    public AwardReportTerm getAwardReportTerm() {
        return this.awardReportTerm;
    }

    public void setAwardReportTerm(AwardReportTerm awardReportTerm) {
        this.awardReportTerm = awardReportTerm;
    }
}

