/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.sql.Date;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.ScheduleData;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.StyleKey;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.committee.rule.event.CommitteeScheduleStartAndEndDateEvent;

public class CommitteeScheduleStartAndEndDateRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<CommitteeScheduleStartAndEndDateEvent> {
    public static final String DOT = ".";

    @Override
    public boolean processRules(CommitteeScheduleStartAndEndDateEvent addCommitteeScheduleEvent) {
        boolean valid = true;
        StringBuilder errorPathBuilder = new StringBuilder();
        errorPathBuilder.append((Object)Constants.committeeHelper).append(DOT);
        errorPathBuilder.append((Object)Constants.scheduleData).append(DOT);
        ScheduleData scheduleData = addCommitteeScheduleEvent.getScheduleData();
        Date startDate = scheduleData.getScheduleStartDate();
        if (startDate == null) {
            errorPathBuilder.append((Object)Constants.scheduleStartDate);
            this.reportError(errorPathBuilder.toString(), "error.committeeSchedule.start.date.blank", new String[0]);
            valid = false;
        } else {
            valid &= this.validateStartDateEndDateAfterOrEquals(scheduleData, errorPathBuilder);
        }
        return valid;
    }

    private boolean validateStartDateEndDateAfterOrEquals(ScheduleData scheduleData, StringBuilder errorPathBuilder) {
        boolean rulePassed = true;
        Date startDate = scheduleData.getScheduleStartDate();
        Date endDate = null;
        String[] msg = new String[1];
        StyleKey key = StyleKey.valueOf(scheduleData.getRecurrenceType());
        switch (key) {
            case NEVER: {
                break;
            }
            case DAILY: {
                endDate = scheduleData.getDailySchedule().getScheduleEndDate();
                rulePassed = !this.isStartDateEndDateAfterOrEquals(startDate, endDate, msg);
                errorPathBuilder.append((Object)Constants.dailySchedule);
                break;
            }
            case WEEKLY: {
                endDate = scheduleData.getWeeklySchedule().getScheduleEndDate();
                rulePassed = !this.isStartDateEndDateAfterOrEquals(startDate, endDate, msg);
                errorPathBuilder.append((Object)Constants.weeklySchedule);
                break;
            }
            case MONTHLY: {
                endDate = scheduleData.getMonthlySchedule().getScheduleEndDate();
                rulePassed = !this.isStartDateEndDateAfterOrEquals(startDate, endDate, msg);
                errorPathBuilder.append((Object)Constants.monthlySchedule);
                break;
            }
            case YEARLY: {
                endDate = scheduleData.getYearlySchedule().getScheduleEndDate();
                rulePassed = !this.isStartDateEndDateAfterOrEquals(startDate, endDate, msg);
                errorPathBuilder.append((Object)Constants.yearlySchedule);
            }
        }
        if (!rulePassed) {
            errorPathBuilder.append(DOT).append((Object)Constants.scheduleEndDate);
            this.reportError(errorPathBuilder.toString(), msg[0], new String[0]);
        }
        return rulePassed;
    }

    private boolean isStartDateEndDateAfterOrEquals(Date startDate, Date endDate, String ... msg) {
        boolean retVal = false;
        if (startDate.toString().equals(endDate.toString())) {
            msg[0] = "error.committeeSchedule.start.and.endDate.equal";
            retVal = true;
        }
        if (!retVal && startDate.after(endDate)) {
            msg[0] = "error.committeeSchedule.start.and.endDate";
            retVal = true;
        }
        return retVal;
    }

    private static enum Constants {
        committeeHelper,
        scheduleData,
        dailySchedule,
        weeklySchedule,
        monthlySchedule,
        yearlySchedule,
        scheduleEndDate,
        scheduleStartDate,
        Date;

    }
}

