/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.amendrenew;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendRenewModule;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendRenewService;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendRenewal;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendmentBean;
import org.kuali.kra.iacuc.actions.notifyiacuc.IacucProtocolNotifyIacucBean;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewServiceImplBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolAmendRenewServiceImpl
extends ProtocolAmendRenewServiceImplBase
implements IacucProtocolAmendRenewService {
    protected static final String CONTINUATION_NEXT_VALUE = "nextContinuationValue";

    @Override
    protected void addModules(ProtocolBase protocol, ProtocolAmendmentBean amendmentBean) {
        ProtocolAmendRenewalBase amendmentEntry = protocol.getProtocolAmendRenewal();
        ProtocolBase currentProtocolByNumber = this.protocolFinderDao.findCurrentProtocolByNumber(protocol.getAmendedProtocolNumber());
        if (amendmentBean.getGeneralInfo()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "001"));
        } else {
            protocol.merge(currentProtocolByNumber, "001");
            amendmentEntry.removeModule("001");
        }
        if (amendmentBean.getAddModifyAttachments()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "008"));
        } else {
            protocol.merge(currentProtocolByNumber, "008");
            amendmentEntry.removeModule("008");
        }
        if (amendmentBean.getAreasOfResearch()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "004"));
        } else {
            protocol.merge(currentProtocolByNumber, "004");
            amendmentEntry.removeModule("004");
        }
        if (amendmentBean.getFundingSource()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "024"));
        } else {
            protocol.merge(currentProtocolByNumber, "024");
            amendmentEntry.removeModule("024");
        }
        if (amendmentBean.getProtocolOrganizations()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "017"));
        } else {
            protocol.merge(currentProtocolByNumber, "017");
            amendmentEntry.removeModule("017");
        }
        if (amendmentBean.getProtocolReferencesAndOtherIdentifiers()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "016"));
        } else {
            protocol.merge(currentProtocolByNumber, "016");
            amendmentEntry.removeModule("016");
        }
        if (amendmentBean.getSubjects()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "006"));
        } else {
            protocol.merge(currentProtocolByNumber, "006");
            amendmentEntry.removeModule("006");
        }
        if (amendmentBean.getSpecialReview()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "007"));
        } else {
            protocol.merge(currentProtocolByNumber, "007");
            amendmentEntry.removeModule("007");
        }
        if (amendmentBean.getOthers()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "023"));
        } else {
            protocol.merge(currentProtocolByNumber, "023");
            amendmentEntry.removeModule("023");
        }
        if (amendmentBean.getProtocolPermissions()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "025"));
        } else {
            protocol.merge(currentProtocolByNumber, "025");
            amendmentEntry.removeModule("025");
        }
        if (amendmentBean.getQuestionnaire()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "026"));
        } else {
            this.removeEditedQuestionaire(protocol);
            amendmentEntry.removeModule("026");
        }
        if (((IacucProtocolAmendmentBean)amendmentBean).getThreers()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "036"));
        } else {
            protocol.merge(currentProtocolByNumber, "036");
            amendmentEntry.removeModule("036");
        }
        if (((IacucProtocolAmendmentBean)amendmentBean).getSpeciesAndGroups()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "032"));
        } else {
            protocol.merge(currentProtocolByNumber, "032");
            amendmentEntry.removeModule("032");
        }
        if (((IacucProtocolAmendmentBean)amendmentBean).getProcedures()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "031"));
        } else {
            protocol.merge(currentProtocolByNumber, "031");
            amendmentEntry.removeModule("031");
        }
        if (((IacucProtocolAmendmentBean)amendmentBean).getProtocolExceptions()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "033"));
        } else {
            protocol.merge(currentProtocolByNumber, "033");
            amendmentEntry.removeModule("033");
        }
        if (amendmentBean.getProtocolPersonnel()) {
            amendmentEntry.addModule(this.createModule(amendmentEntry, "002"));
        } else {
            protocol.merge(currentProtocolByNumber, "002");
            amendmentEntry.removeModule("002");
        }
    }

    @Override
    public String createFYI(ProtocolDocumentBase protocolDocument, IacucProtocolNotifyIacucBean fyiBean) throws Exception {
        return this.createFYI(protocolDocument, fyiBean.getActionHelper(), fyiBean.getComment());
    }

    @Override
    protected ProtocolAmendmentBean getFyiAttachmentsBean(ActionHelperBase actionHelper) {
        IacucProtocolAmendmentBean fyiAttachmentsBean = new IacucProtocolAmendmentBean((IacucActionHelper)actionHelper);
        fyiAttachmentsBean.setAddModifyAttachments(true);
        return fyiAttachmentsBean;
    }

    @Override
    protected ProtocolActionBase getNewAmendmentProtocolActionInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolAction((IacucProtocol)protocol, "102");
    }

    @Override
    protected ProtocolActionBase getNewRenewalProtocolActionInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolAction((IacucProtocol)protocol, "104");
    }

    @Override
    protected ProtocolActionBase getNewRenewalWithAmendmentProtocolActionInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolAction((IacucProtocol)protocol, "909");
    }

    @Override
    protected ProtocolActionBase getNewFyiProtocolActionInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolAction((IacucProtocol)protocol, "114");
    }

    @Override
    protected ModuleQuestionnaireBean getNewProtocolModuleQuestionnaireBeanInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolModuleQuestionnaireBean((IacucProtocol)protocol);
    }

    @Override
    protected String getAmendmentInProgressStatusHook() {
        return "205";
    }

    @Override
    protected String getRenewalInProgressStatusHook() {
        return "206";
    }

    @Override
    protected String getFyiInProgressStatusHook() {
        return "900";
    }

    @Override
    protected List<String> getAllModuleTypeCodes() {
        ArrayList<String> moduleTypeCodes = new ArrayList<String>();
        moduleTypeCodes.add("001");
        moduleTypeCodes.add("008");
        moduleTypeCodes.add("004");
        moduleTypeCodes.add("024");
        moduleTypeCodes.add("023");
        moduleTypeCodes.add("017");
        moduleTypeCodes.add("002");
        moduleTypeCodes.add("016");
        moduleTypeCodes.add("007");
        moduleTypeCodes.add("006");
        moduleTypeCodes.add("025");
        moduleTypeCodes.add("026");
        moduleTypeCodes.add("036");
        moduleTypeCodes.add("032");
        moduleTypeCodes.add("031");
        moduleTypeCodes.add("033");
        return moduleTypeCodes;
    }

    @Override
    protected Class<? extends ProtocolBase> getProtocolBOClassHook() {
        return IacucProtocol.class;
    }

    @Override
    protected ProtocolAmendRenewalBase getNewProtocolAmendRenewalInstanceHook() {
        return new IacucProtocolAmendRenewal();
    }

    @Override
    protected ProtocolAmendRenewModuleBase getNewProtocolAmendRenewModuleInstanceHook() {
        return new IacucProtocolAmendRenewModule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createContinuation(IacucProtocolDocument protocolDocument, String continuationSummary) throws Exception {
        IacucProtocolDocument continuationProtocolDocument = null;
        try {
            GlobalVariables.getUserSession().addObject("onAmendAndRenewAllowNewProtocolDocument", (Object)Boolean.TRUE);
            continuationProtocolDocument = (IacucProtocolDocument)this.getProtocolCopyService().copyProtocol(protocolDocument, this.generateProtocolContinuationNumber(protocolDocument), true);
        }
        finally {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
        }
        continuationProtocolDocument.getProtocol().setInitialSubmissionDate(protocolDocument.getProtocol().getInitialSubmissionDate());
        continuationProtocolDocument.getProtocol().setApprovalDate(protocolDocument.getProtocol().getApprovalDate());
        continuationProtocolDocument.getProtocol().setExpirationDate(protocolDocument.getProtocol().getExpirationDate());
        continuationProtocolDocument.getProtocol().setLastApprovalDate(protocolDocument.getProtocol().getLastApprovalDate());
        continuationProtocolDocument.getProtocol().setProtocolStatusCode("207");
        continuationProtocolDocument.getProtocol().refreshReferenceObject("protocolStatus");
        this.markProtocolAttachmentsAsFinalized(continuationProtocolDocument.getProtocol().getAttachmentProtocols());
        IacucProtocolAction protocolAction = this.createCreateContinuationProtocolAction(protocolDocument.getIacucProtocol(), continuationProtocolDocument.getIacucProtocol().getProtocolNumber());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
        ProtocolAmendRenewalBase protocolAmendRenewal = this.createAmendmentRenewal(protocolDocument, continuationProtocolDocument, continuationSummary);
        continuationProtocolDocument.getProtocol().setProtocolAmendRenewal(protocolAmendRenewal);
        this.documentService.saveDocument((Document)protocolDocument);
        this.documentService.saveDocument((Document)continuationProtocolDocument);
        return continuationProtocolDocument.getDocumentNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createContinuationWithAmendment(IacucProtocolDocument protocolDocument, ProtocolAmendmentBean amendmentBean) throws Exception {
        IacucProtocolDocument continuationProtocolDocument = null;
        try {
            GlobalVariables.getUserSession().addObject("onAmendAndRenewAllowNewProtocolDocument", (Object)Boolean.TRUE);
            continuationProtocolDocument = (IacucProtocolDocument)this.getProtocolCopyService().copyProtocol(protocolDocument, this.generateProtocolContinuationNumber(protocolDocument), true);
        }
        finally {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
        }
        continuationProtocolDocument.getProtocol().setInitialSubmissionDate(protocolDocument.getProtocol().getInitialSubmissionDate());
        continuationProtocolDocument.getProtocol().setApprovalDate(protocolDocument.getProtocol().getApprovalDate());
        continuationProtocolDocument.getProtocol().setExpirationDate(protocolDocument.getProtocol().getExpirationDate());
        continuationProtocolDocument.getProtocol().setLastApprovalDate(protocolDocument.getProtocol().getLastApprovalDate());
        continuationProtocolDocument.getProtocol().setProtocolStatusCode("207");
        continuationProtocolDocument.getProtocol().refreshReferenceObject("protocolStatus");
        this.markProtocolAttachmentsAsFinalized(continuationProtocolDocument.getProtocol().getAttachmentProtocols());
        IacucProtocolAction protocolAction = this.createCreateContinuationProtocolAction(protocolDocument.getIacucProtocol(), continuationProtocolDocument.getProtocol().getProtocolNumber());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
        return this.createAmendment(protocolDocument, continuationProtocolDocument, amendmentBean);
    }

    protected String generateProtocolContinuationNumber(IacucProtocolDocument protocolDocument) {
        return this.generateProtocolNumber(protocolDocument, ProtocolSpecialVersion.CONTINUATION.getCode(), CONTINUATION_NEXT_VALUE);
    }

    protected IacucProtocolAction createCreateContinuationProtocolAction(IacucProtocol protocol, String protocolNumber) {
        IacucProtocolAction protocolAction = new IacucProtocolAction(protocol, "103");
        protocolAction.setComments(ProtocolSpecialVersion.CONTINUATION.getDescription() + "-" + protocolNumber.substring(11) + ": Created");
        return protocolAction;
    }

    @Override
    public Collection<IacucProtocol> getContinuations(String protocolNumber) throws Exception {
        ArrayList<IacucProtocol> continuations = new ArrayList<IacucProtocol>();
        Collection protocols = this.kraLookupDao.findCollectionUsingWildCard(IacucProtocol.class, "protocolNumber", protocolNumber + ProtocolSpecialVersion.CONTINUATION.getCode() + "%", true);
        for (ProtocolBase protocol : protocols) {
            IacucProtocolDocument protocolDocument = (IacucProtocolDocument)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
            continuations.add(protocolDocument.getIacucProtocol());
        }
        return continuations;
    }

    @Override
    public List<ProtocolBase> getAmendmentAndRenewals(String protocolNumber) throws Exception {
        List<ProtocolBase> protocols = super.getAmendmentAndRenewals(protocolNumber);
        protocols.addAll(this.getContinuations(protocolNumber));
        return protocols;
    }
}

