/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.iacuc.IacucPersonTraining;
import org.kuali.kra.iacuc.personnel.IacucProtocolPerson;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;

public class IacucProcedurePersonResponsible
extends KcPersistableBusinessObjectBase {
    private static final long serialVersionUID = 1L;
    private Integer iacucProcedurePersonResponsibleId;
    private Integer iacucProtocolStudyGroupId;
    private Integer protocolPersonId;
    private IacucProtocolPerson protocolPerson;
    private List<String> trainingDetails;
    private IacucProtocolStudyGroup iacucProtocolStudyGroup;

    public Integer getIacucProcedurePersonResponsibleId() {
        return this.iacucProcedurePersonResponsibleId;
    }

    public void setIacucProcedurePersonResponsibleId(Integer iacucProcedurePersonResponsibleId) {
        this.iacucProcedurePersonResponsibleId = iacucProcedurePersonResponsibleId;
    }

    public String getPersonId() {
        return this.getProtocolPerson().getPersonId();
    }

    public void resetPersistenceState() {
        this.setIacucProcedurePersonResponsibleId(null);
    }

    public String getTrainingDetailsString() {
        Object details = new String();
        boolean first = true;
        for (String detail : this.getTrainingDetails()) {
            if (!first) {
                details = (String)details + "<br/>";
            }
            details = (String)details + detail;
            first = false;
        }
        return details;
    }

    public List<String> getTrainingDetails() {
        this.trainingDetails = new ArrayList<String>();
        List<IacucPersonTraining> iacucPersonTrainings = this.getProtocolPerson().getIacucPersonTrainings();
        if (iacucPersonTrainings != null) {
            for (IacucPersonTraining iacucPersonTraining : iacucPersonTrainings) {
                StringBuffer trainingInfo = new StringBuffer();
                trainingInfo.append("Training : " + iacucPersonTraining.getPersonTraining().getTraining().getDescription());
                trainingInfo.append("\r\nSpecies : " + iacucPersonTraining.getIacucSpecies().getSpeciesName());
                trainingInfo.append("\r\nProcedure : " + iacucPersonTraining.getIacucProcedure().getProcedureDescription());
                trainingInfo.append("\r\n");
                this.trainingDetails.add(trainingInfo.toString());
            }
        }
        return this.trainingDetails;
    }

    public String getPersonResponsibleDescription() {
        return this.getProtocolPerson().getProcedureQualificationDescription();
    }

    public String getPersonName() {
        return this.getProtocolPerson().getPersonName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IacucProcedurePersonResponsible other = (IacucProcedurePersonResponsible)obj;
        if (this.iacucProcedurePersonResponsibleId == null ? other.iacucProcedurePersonResponsibleId != null : !this.iacucProcedurePersonResponsibleId.equals(other.iacucProcedurePersonResponsibleId)) {
            return false;
        }
        if (this.iacucProtocolStudyGroupId == null ? other.iacucProtocolStudyGroupId != null : !this.iacucProtocolStudyGroupId.equals(other.iacucProtocolStudyGroupId)) {
            return false;
        }
        return !(this.protocolPersonId == null ? other.protocolPersonId != null : !this.protocolPersonId.equals(other.protocolPersonId));
    }

    public int hashCode() {
        int result = this.iacucProcedurePersonResponsibleId != null ? this.iacucProcedurePersonResponsibleId.hashCode() : 0;
        result = 31 * result + (this.iacucProtocolStudyGroupId != null ? this.iacucProtocolStudyGroupId.hashCode() : 0);
        result = 31 * result + (this.protocolPersonId != null ? this.protocolPersonId.hashCode() : 0);
        return result;
    }

    public Integer getProtocolPersonId() {
        return this.protocolPersonId;
    }

    public void setProtocolPersonId(Integer protocolPersonId) {
        this.protocolPersonId = protocolPersonId;
    }

    public IacucProtocolPerson getProtocolPerson() {
        if (this.protocolPerson == null) {
            this.refreshReferenceObject("protocolPerson");
        }
        return this.protocolPerson;
    }

    public void setProtocolPerson(IacucProtocolPerson protocolPerson) {
        this.protocolPerson = protocolPerson;
    }

    public Integer getIacucProtocolStudyGroupId() {
        return this.iacucProtocolStudyGroupId;
    }

    public void setIacucProtocolStudyGroupId(Integer iacucProtocolStudyGroupId) {
        this.iacucProtocolStudyGroupId = iacucProtocolStudyGroupId;
    }

    public IacucProtocolStudyGroup getIacucProtocolStudyGroup() {
        if (this.iacucProtocolStudyGroup == null) {
            this.refreshReferenceObject("iacucProtocolStudyGroup");
        }
        return this.iacucProtocolStudyGroup;
    }

    public void setIacucProtocolStudyGroup(IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        this.iacucProtocolStudyGroup = iacucProtocolStudyGroup;
    }
}

