/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.workflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class ActiveCommitteeMemberDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private CommitteeService committeeService;
    private static final Logger LOG = LogManager.getLogger(ActiveCommitteeMemberDerivedRoleTypeServiceImpl.class);
    private static final String DEFAULT_QUALIFYING_COMMITTEE_MEMBERSHIP_TYPE_CODE = "1";
    protected Set<String> qualifyingCommitteeMembershipTypeCodes;
    protected List<String> requiredAttributes = new ArrayList<String>();

    public ActiveCommitteeMemberDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("committee");
    }

    public void init() {
        if (this.qualifyingCommitteeMembershipTypeCodes == null) {
            LOG.info(String.format("No qualifying committee membership type codes were specified, defaulting to type code %s.", DEFAULT_QUALIFYING_COMMITTEE_MEMBERSHIP_TYPE_CODE));
            this.qualifyingCommitteeMembershipTypeCodes = new HashSet<String>();
            this.qualifyingCommitteeMembershipTypeCodes.add(DEFAULT_QUALIFYING_COMMITTEE_MEMBERSHIP_TYPE_CODE);
        }
    }

    private boolean isQualified(CommitteeMembership membership, Map<String, String> qualification) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Checking qualification of membership:%s", membership));
        }
        boolean result = membership.isActive();
        if (this.qualifyingCommitteeMembershipTypeCodes.size() > 0) {
            if (LOG.isDebugEnabled() && !this.qualifyingCommitteeMembershipTypeCodes.contains(membership.getMembershipTypeCode())) {
                LOG.debug(String.format("Membership %s does not have membership type code in the qualifying map.", membership));
            }
            result &= this.qualifyingCommitteeMembershipTypeCodes.contains(membership.getMembershipTypeCode());
        }
        return result;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        Committee committee;
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String committeeId = qualification.get("committee");
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Running getRoleMembersFromDerivedRole for committee %s", committeeId));
        }
        if (!StringUtils.isEmpty((CharSequence)committeeId) && (committee = (Committee)this.committeeService.getCommitteeById(committeeId)) != null) {
            for (CommitteeMembershipBase membership : committee.getCommitteeMemberships()) {
                if (!this.isQualified((CommitteeMembership)membership, qualification)) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)membership.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(String.format("Adding principal %s for getRoleMembersFromDerivedRole for committee %s", membership.getPersonId(), committee));
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        Committee committee;
        this.validateRequiredAttributesAgainstReceived(qualification);
        String committeeId = qualification.get("committee");
        if (!StringUtils.isEmpty((CharSequence)committeeId) && (committee = (Committee)this.committeeService.getCommitteeById(committeeId)) != null) {
            for (CommitteeMembershipBase membership : committee.getCommitteeMemberships()) {
                if (!this.isQualified((CommitteeMembership)membership, qualification) || membership.getPersonId() == null || !StringUtils.equals((CharSequence)principalId, (CharSequence)membership.getPersonId())) continue;
                return true;
            }
        }
        return false;
    }

    public CommitteeService getCommitteeService() {
        return this.committeeService;
    }

    public void setCommitteeService(CommitteeService committeeService) {
        this.committeeService = committeeService;
    }

    public List<String> getQualifiersForExactMatch() {
        ArrayList<String> quals = new ArrayList<String>();
        quals.add("committee");
        return quals;
    }

    public Set<String> getQualifyingCommitteeMembershipTypeCodes() {
        return this.qualifyingCommitteeMembershipTypeCodes;
    }

    public void setQualifyingCommitteeMembershipTypeCodes(Set<String> qualifyingCommitteeMembershipTypeCodes) {
        this.qualifyingCommitteeMembershipTypeCodes = qualifyingCommitteeMembershipTypeCodes;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

