/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.note;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.note.NoteService;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.notes.dao.NoteDAO;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class NoteServiceImpl
implements NoteService {
    private NoteDAO noteDao;
    private DataObjectService dataObjectService;

    public List<org.kuali.rice.kew.api.note.Note> getNotes(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        List<Note> noteBos = this.getNoteDao().getNotesByDocumentId(documentId);
        if (noteBos == null) {
            return Collections.emptyList();
        }
        ArrayList<org.kuali.rice.kew.api.note.Note> notes = new ArrayList<org.kuali.rice.kew.api.note.Note>();
        for (Note noteBo : noteBos) {
            notes.add(Note.to(noteBo));
        }
        return Collections.unmodifiableList(notes);
    }

    public org.kuali.rice.kew.api.note.Note getNote(String noteId) {
        if (StringUtils.isBlank((String)noteId)) {
            throw new RiceIllegalArgumentException("noteId was null or blank");
        }
        Note noteBo = (Note)this.getDataObjectService().find(Note.class, (Object)noteId);
        return Note.to(noteBo);
    }

    public org.kuali.rice.kew.api.note.Note createNote(org.kuali.rice.kew.api.note.Note note) {
        if (note == null) {
            throw new RiceIllegalArgumentException("note was null");
        }
        if (note.getId() != null) {
            throw new RiceIllegalArgumentException("Attempted to create a note that already has an id assigned, id must be null upon creation");
        }
        if (note.getVersionNumber() != null) {
            throw new RiceIllegalArgumentException("Attempted to create a note that already has a version number assigned, version number must be null upon creation");
        }
        Note noteBo = Note.from(note);
        if (noteBo.getNoteCreateDate() == null) {
            noteBo.setNoteCreateDate(new Timestamp(System.currentTimeMillis()));
        }
        noteBo = (Note)this.getDataObjectService().save((Object)noteBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return Note.to(noteBo);
    }

    public org.kuali.rice.kew.api.note.Note updateNote(org.kuali.rice.kew.api.note.Note note) {
        if (note == null) {
            throw new RiceIllegalArgumentException("note was null");
        }
        if (note.getId() == null) {
            throw new RiceIllegalArgumentException("Attempted to update a note without an id, id must be present when updating");
        }
        if (note.getVersionNumber() == null) {
            throw new RiceIllegalArgumentException("Attempted to update a note without a version number, version number must be present when updating");
        }
        if (note.getCreateDate() == null) {
            throw new RiceIllegalArgumentException("Attempted to update a note without a create date, note must have a create date");
        }
        org.kuali.rice.kew.api.note.Note existingNoteBo = this.getNote(note.getId());
        if (existingNoteBo == null) {
            throw new RiceIllegalArgumentException("Attempted to udpate a note with an id for a not that does not exist: " + note.getId());
        }
        Note noteBo = Note.from(note);
        this.getDataObjectService().save((Object)noteBo, new PersistenceOption[0]);
        return Note.to(noteBo);
    }

    public org.kuali.rice.kew.api.note.Note deleteNote(String noteId) {
        if (StringUtils.isBlank((String)noteId)) {
            throw new RiceIllegalArgumentException("noteId was null or blank");
        }
        Note noteBo = (Note)this.getDataObjectService().find(Note.class, (Object)noteId);
        if (noteBo == null) {
            throw new RiceIllegalArgumentException("A note does not exist for the given note id: " + noteId);
        }
        org.kuali.rice.kew.api.note.Note deletedNote = Note.to(noteBo);
        this.getDataObjectService().delete((Object)noteBo);
        return deletedNote;
    }

    public void setNoteDao(NoteDAO noteDao) {
        this.noteDao = noteDao;
    }

    public NoteDAO getNoteDao() {
        return this.noteDao;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

