/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.timeandmoney;

import java.io.Serializable;
import java.sql.Date;
import java.util.List;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistributionRuleEvent;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public class AwardDirectFandADistributionBean
implements Serializable {
    private static final long serialVersionUID = 6274443203617122440L;
    private TimeAndMoneyForm parent;
    private AwardDirectFandADistribution newAwardDirectFandADistribution;
    transient AwardAmountInfoService awardAmountInfoService;

    public AwardDirectFandADistributionBean(TimeAndMoneyForm parent) {
        this.parent = parent;
        this.setNewAwardDirectFandADistribution(new AwardDirectFandADistribution());
    }

    public AwardDirectFandADistributionBean() {
    }

    public void init() {
        this.newAwardDirectFandADistribution = new AwardDirectFandADistribution();
    }

    public TimeAndMoneyForm getParent() {
        return this.parent;
    }

    public void setParent(TimeAndMoneyForm parent) {
        this.parent = parent;
    }

    public TimeAndMoneyDocument getTimeAndMoneyDocument() {
        return this.parent.getTimeAndMoneyDocument();
    }

    public AwardDirectFandADistribution getNewAwardDirectFandADistribution() {
        return this.newAwardDirectFandADistribution;
    }

    public void setNewAwardDirectFandADistribution(AwardDirectFandADistribution newAwardDirectFandADistribution) {
        this.newAwardDirectFandADistribution = newAwardDirectFandADistribution;
    }

    public boolean addAwardDirectFandADistribution(AwardDirectFandADistributionBean awardDirectFandADistributionBean) throws Exception {
        AwardDirectFandADistribution thisNewAwardDirectFandADistribution;
        TimeAndMoneyForm timeAndMoneyForm = awardDirectFandADistributionBean.getParent();
        if (this.applyAddRulesToTarget(timeAndMoneyForm, thisNewAwardDirectFandADistribution = awardDirectFandADistributionBean.getNewAwardDirectFandADistribution())) {
            this.findIndexAndAddTarget(awardDirectFandADistributionBean);
        }
        return true;
    }

    private void findIndexAndAddTarget(AwardDirectFandADistributionBean awardDirectFandADistributionBean) {
        Award award = awardDirectFandADistributionBean.getTimeAndMoneyDocument().getAward();
        List<AwardDirectFandADistribution> awardDirectFandADistributions = awardDirectFandADistributionBean.getTimeAndMoneyDocument().getAward().getAwardDirectFandADistributions();
        AwardDirectFandADistribution thisNewAwardDirectFandADistribution = awardDirectFandADistributionBean.getNewAwardDirectFandADistribution();
        int index = 0;
        if (awardDirectFandADistributions.size() == 0) {
            award.add(index, thisNewAwardDirectFandADistribution);
            awardDirectFandADistributionBean.init();
        } else if (this.canTargetBeInsertedIntoLastIndex(awardDirectFandADistributions, thisNewAwardDirectFandADistribution, this.getAwardAmountInfoService().fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos()).getFinalExpirationDate())) {
            award.add(thisNewAwardDirectFandADistribution);
            awardDirectFandADistributionBean.init();
        } else {
            for (AwardDirectFandADistribution awardDirectFandADistribution : award.getAwardDirectFandADistributions()) {
                if (awardDirectFandADistribution.getEndDate().compareTo(thisNewAwardDirectFandADistribution.getStartDate()) == -1) {
                    ++index;
                    continue;
                }
                award.add(index, thisNewAwardDirectFandADistribution);
                awardDirectFandADistributionBean.init();
                break;
            }
        }
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        this.awardAmountInfoService = KcServiceLocator.getService(AwardAmountInfoService.class);
        return this.awardAmountInfoService;
    }

    private boolean canTargetBeInsertedIntoLastIndex(List<AwardDirectFandADistribution> awardDirectFandADistributions, AwardDirectFandADistribution thisNewAwardDirectFandADistribution, Date projectEndDate) {
        boolean isDistrEndDateBeforeProjectEndDate;
        boolean bl = isDistrEndDateBeforeProjectEndDate = thisNewAwardDirectFandADistribution.getEndDate().before(projectEndDate) || thisNewAwardDirectFandADistribution.getEndDate().equals(projectEndDate);
        if (awardDirectFandADistributions.isEmpty()) {
            return isDistrEndDateBeforeProjectEndDate;
        }
        AwardDirectFandADistribution lastItemInList = awardDirectFandADistributions.get(awardDirectFandADistributions.size() - 1);
        return lastItemInList.getEndDate().before(thisNewAwardDirectFandADistribution.getStartDate()) && isDistrEndDateBeforeProjectEndDate;
    }

    private boolean applyAddRulesToTarget(TimeAndMoneyForm timeAndMoneyForm, AwardDirectFandADistribution thisNewAwardDirectFandADistribution) {
        return this.getKualiRuleService().applyRules((DocumentEvent)new AwardDirectFandADistributionRuleEvent("", timeAndMoneyForm.getTimeAndMoneyDocument(), thisNewAwardDirectFandADistribution));
    }

    public void updateBudgetPeriodsAfterDelete(List<AwardDirectFandADistribution> awardDirectFandADistributions) {
        int index = 1;
        for (AwardDirectFandADistribution awardDirectFandADistribution : awardDirectFandADistributions) {
            awardDirectFandADistribution.setBudgetPeriod(index);
            ++index;
        }
    }

    protected KualiRuleService getKualiRuleService() {
        return KcServiceLocator.getService(KualiRuleService.class);
    }
}

