/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.api.sponsor.SponsorService;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.FundingSourceType;
import org.kuali.kra.protocol.protocol.funding.AddProtocolFundingSourceEventBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService;

public abstract class ProtocolFundingSourceRuleBase
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<AddProtocolFundingSourceEventBase> {
    private ProtocolFundingSourceService protocolFundingSourceService;

    public boolean processAddProtocolFundingSourceBusinessRules(AddProtocolFundingSourceEventBase addProtocolFundingSourceEvent) {
        boolean isValid = true;
        ProtocolFundingSourceBase fundingSrc = addProtocolFundingSourceEvent.getFundingSource();
        if (fundingSrc == null) {
            isValid = false;
            this.reportError("protocolHelper.newFundingSource.fundingSourceTypeCode", "error.protocolFundingSource.fundingSourceType.notFound", new String[0]);
        } else {
            isValid &= this.checkFundingSource(fundingSrc);
            isValid &= this.checkForDuplicates(addProtocolFundingSourceEvent);
        }
        return isValid;
    }

    @Override
    public boolean processRules(AddProtocolFundingSourceEventBase addProtocolFundingSourceEvent) {
        return this.processAddProtocolFundingSourceBusinessRules(addProtocolFundingSourceEvent);
    }

    private boolean checkFundingSource(ProtocolFundingSourceBase fundingSource) {
        boolean isValid = true;
        FundingSourceType fundingSourceType = fundingSource.getFundingSourceType();
        String fundingSourceNumber = fundingSource.getFundingSourceNumber();
        String fundingSourceName = fundingSource.getFundingSourceName();
        String fundingSourceTypeCode = fundingSource.getFundingSourceTypeCode();
        if (StringUtils.isBlank((CharSequence)fundingSource.getFundingSourceTypeCode())) {
            isValid = false;
            this.reportError("protocolHelper.newFundingSource.fundingSourceTypeCode", "error.protocolFundingSource.fundingSourceType.notFound", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)fundingSourceNumber)) {
            isValid = false;
            this.reportError("protocolHelper.newFundingSource.fundingSourceNumber", "error.protocolFundingSource.fundingSourceNumber.notFound", new String[0]);
        } else if (fundingSourceType != null && !this.getProtocolFundingSourceService().isValidIdForType(fundingSource)) {
            isValid = false;
            this.reportError("protocolHelper.newFundingSource.fundingSourceNumber", "error.protocolFundingSource.fundingSourceNumber.invalidForType", fundingSourceType.getDescription(), fundingSourceNumber);
        }
        if (StringUtils.isBlank((CharSequence)fundingSourceName) && StringUtils.isNotBlank((CharSequence)fundingSource.getFundingSourceTypeCode()) && this.getProtocolFundingSourceService().isEditable(fundingSource.getFundingSourceTypeCode()) && !"3".equals(fundingSourceTypeCode)) {
            isValid = false;
            this.reportError("protocolHelper.newFundingSource.fundingSourceName", "error.protocolFundingSource.fundingSourceName.notFound", new String[0]);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)fundingSource.getFundingSourceTypeCode(), (CharSequence)"1")) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("sponsorCode", fundingSource.getFundingSourceNumber());
            Sponsor sp = (Sponsor)this.getBusinessObjectService().findByPrimaryKey(Sponsor.class, fieldValues);
            if (!this.getSponsorService().isValidSponsor((SponsorContract)sp)) {
                isValid = false;
                this.reportError("protocolHelper.newFundingSource.fundingSourceNumber", "error.invalid.sponsorCode", new String[0]);
            }
        }
        return isValid;
    }

    private boolean checkForDuplicates(AddProtocolFundingSourceEventBase addProtocolFundingSourceEvent) {
        boolean isValid = true;
        ProtocolFundingSourceBase fundingSrc = addProtocolFundingSourceEvent.getFundingSource();
        List<ProtocolFundingSourceBase> fundingSources = addProtocolFundingSourceEvent.getProtocolFundingSources();
        for (ProtocolFundingSourceBase theFundingSource : fundingSources) {
            if (!fundingSrc.equals(theFundingSource)) continue;
            isValid = false;
            this.reportError("protocolHelper.newFundingSource.fundingSourceNumber", "error.protocolFundingSource.fundingSource.duplicate", new String[0]);
        }
        return isValid;
    }

    private ProtocolFundingSourceService getProtocolFundingSourceService() {
        if (this.protocolFundingSourceService == null) {
            this.protocolFundingSourceService = KcServiceLocator.getService(this.getProtocolFundingSourceServiceClassHook());
        }
        return this.protocolFundingSourceService;
    }

    protected abstract Class<? extends ProtocolFundingSourceService> getProtocolFundingSourceServiceClassHook();

    public void setProtocolFundingSourceService(ProtocolFundingSourceService protocolFundingSourceService) {
        this.protocolFundingSourceService = protocolFundingSourceService;
    }

    private SponsorService getSponsorService() {
        return KcServiceLocator.getService(SponsorService.class);
    }
}

