/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.summary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.protocol.summary.ProtocolSummary;
import org.kuali.kra.protocol.summary.UnitSummary;

public class PersonnelSummary
implements Serializable {
    private static final long serialVersionUID = 5043509130587736483L;
    private String personId;
    private String name;
    private String roleName;
    private String affiliation;
    private List<UnitSummary> units = new ArrayList<UnitSummary>();
    private boolean nameChanged;
    private boolean roleNameChanged;
    private boolean affiliationChanged;

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    public List<UnitSummary> getUnits() {
        return this.units;
    }

    public void addUnit(String unitNumber, String unitName) {
        this.units.add(new UnitSummary(unitNumber, unitName));
    }

    public void compare(ProtocolSummary other) {
        PersonnelSummary otherPerson = other.findPerson(this.personId);
        if (otherPerson == null) {
            this.nameChanged = true;
            this.roleNameChanged = true;
            this.affiliationChanged = true;
            for (UnitSummary unit : this.units) {
                unit.setChanged(true);
            }
        } else {
            this.nameChanged = !StringUtils.equals((CharSequence)this.name, (CharSequence)otherPerson.name);
            this.roleNameChanged = !StringUtils.equals((CharSequence)this.roleName, (CharSequence)otherPerson.roleName);
            this.affiliationChanged = !StringUtils.equals((CharSequence)this.affiliation, (CharSequence)otherPerson.affiliation);
            for (UnitSummary unit : this.units) {
                unit.compare(otherPerson);
            }
        }
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public boolean isRoleNameChanged() {
        return this.roleNameChanged;
    }

    public boolean isAffiliationChanged() {
        return this.affiliationChanged;
    }

    public UnitSummary findUnit(String unitNumber) {
        for (UnitSummary unit : this.units) {
            if (!StringUtils.equals((CharSequence)unit.getUnitNumber(), (CharSequence)unitNumber)) continue;
            return unit;
        }
        return null;
    }
}

