/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Map;
import org.springframework.amqp.core.AbstractDeclarable;

public class Binding
extends AbstractDeclarable {
    private final String destination;
    private final String exchange;
    private final String routingKey;
    private final Map<String, Object> arguments;
    private final DestinationType destinationType;

    public Binding(String destination, DestinationType destinationType, String exchange, String routingKey, Map<String, Object> arguments) {
        this.destination = destination;
        this.destinationType = destinationType;
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.arguments = arguments;
    }

    public String getDestination() {
        return this.destination;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public boolean isDestinationQueue() {
        return DestinationType.QUEUE.equals((Object)this.destinationType);
    }

    public String toString() {
        return "Binding [destination=" + this.destination + ", exchange=" + this.exchange + ", routingKey=" + this.routingKey + "]";
    }

    public static enum DestinationType {
        QUEUE,
        EXCHANGE;

    }
}

