/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.framework.type.ActionTypeService;
import org.kuali.rice.krms.framework.type.AgendaTypeService;
import org.kuali.rice.krms.framework.type.RuleTypeService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.type.ActionTypeServiceBase;
import org.kuali.rice.krms.impl.type.AgendaTypeServiceBase;
import org.kuali.rice.krms.impl.type.RuleTypeServiceBase;
import org.kuali.rice.krms.impl.ui.AgendaEditor;

public class KrmsRetriever {
    private static final long serialVersionUID = 1L;

    public List<RemotableAttributeField> retrieveRuleActionCustomAttributes(AgendaEditor agendaEditor) {
        ArrayList<RemotableAttributeField> results = new ArrayList<RemotableAttributeField>();
        if (agendaEditor != null && agendaEditor.getAgendaItemLineRuleAction() != null && !StringUtils.isBlank((String)agendaEditor.getAgendaItemLineRuleAction().getTypeId())) {
            ActionTypeService actionTypeService = this.getActionTypeService(agendaEditor.getAgendaItemLineRuleAction().getTypeId());
            results.addAll(actionTypeService.getAttributeFields(agendaEditor.getAgendaItemLineRuleAction().getTypeId()));
        }
        return results;
    }

    private AgendaEditor getAgendaEditor(Object model) {
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)model;
        return (AgendaEditor)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject();
    }

    private ActionTypeService getActionTypeService(String krmsTypeId) {
        String serviceName;
        KrmsTypeDefinition krmsType = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService().getTypeById(krmsTypeId);
        ActionTypeService actionTypeService = null;
        if (!StringUtils.isBlank((String)krmsTypeId) && !StringUtils.isBlank((String)(serviceName = krmsType.getServiceName()))) {
            actionTypeService = (ActionTypeService)KrmsRepositoryServiceLocator.getService(serviceName);
        }
        if (actionTypeService == null) {
            actionTypeService = ActionTypeServiceBase.defaultActionTypeService;
        }
        return actionTypeService;
    }

    public List<RemotableAttributeField> retrieveAgendaCustomAttributes(AgendaEditor agendaEditor) {
        ArrayList<RemotableAttributeField> results = new ArrayList<RemotableAttributeField>();
        if (agendaEditor != null && agendaEditor.getAgenda() != null && !StringUtils.isBlank((String)agendaEditor.getAgenda().getTypeId())) {
            String krmsTypeId = agendaEditor.getAgenda().getTypeId();
            AgendaTypeService agendaTypeService = this.getAgendaTypeService(krmsTypeId);
            results.addAll(agendaTypeService.getAttributeFields(krmsTypeId));
        }
        return results;
    }

    private AgendaTypeService getAgendaTypeService(String krmsTypeId) {
        String serviceName;
        KrmsTypeDefinition krmsType = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService().getTypeById(krmsTypeId);
        AgendaTypeService agendaTypeService = null;
        if (!StringUtils.isBlank((String)krmsTypeId) && !StringUtils.isBlank((String)(serviceName = krmsType.getServiceName()))) {
            agendaTypeService = (AgendaTypeService)KrmsRepositoryServiceLocator.getService(serviceName);
        }
        if (agendaTypeService == null) {
            agendaTypeService = AgendaTypeServiceBase.defaultAgendaTypeService;
        }
        return agendaTypeService;
    }

    public List<RemotableAttributeField> retrieveRuleCustomAttributes(AgendaEditor agendaEditor) {
        ArrayList<RemotableAttributeField> results = new ArrayList<RemotableAttributeField>();
        if (agendaEditor != null && agendaEditor.getAgendaItemLine() != null && agendaEditor.getAgendaItemLine().getRule() != null && !StringUtils.isBlank((String)agendaEditor.getAgendaItemLine().getRule().getTypeId())) {
            String krmsTypeId = agendaEditor.getAgendaItemLine().getRule().getTypeId();
            RuleTypeService ruleTypeService = this.getRuleTypeService(krmsTypeId);
            results.addAll(ruleTypeService.getAttributeFields(krmsTypeId));
        }
        return results;
    }

    private RuleTypeService getRuleTypeService(String krmsTypeId) {
        RuleTypeService ruleTypeService = null;
        String serviceName = this.getRuleTypeServiceName(krmsTypeId);
        if (!StringUtils.isBlank((String)serviceName)) {
            ruleTypeService = (RuleTypeService)KrmsRepositoryServiceLocator.getService(serviceName);
        }
        if (ruleTypeService == null) {
            ruleTypeService = RuleTypeServiceBase.defaultRuleTypeService;
        }
        return ruleTypeService;
    }

    private String getRuleTypeServiceName(String krmsTypeId) {
        String serviceName = null;
        KrmsTypeDefinition krmsType = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService().getTypeById(krmsTypeId);
        if (!StringUtils.isBlank((String)krmsTypeId)) {
            serviceName = krmsType.getServiceName();
        }
        return serviceName;
    }
}

