/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.action.ActionInvocationQueue;
import org.kuali.rice.kew.api.action.RolePokerQueue;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.actionlist.ActionListService;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.document.DocumentOrchestrationQueue;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.extension.ExtensionRepositoryService;
import org.kuali.rice.kew.api.group.GroupMembershipChangeQueue;
import org.kuali.rice.kew.api.mail.ImmediateEmailReminderQueue;
import org.kuali.rice.kew.api.note.NoteService;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowService;
import org.kuali.rice.kew.api.preferences.PreferencesService;
import org.kuali.rice.kew.api.repository.type.KewTypeRepositoryService;
import org.kuali.rice.kew.api.responsibility.ResponsibilityChangeQueue;
import org.kuali.rice.kew.api.rule.RuleService;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;

public class KewApiServiceLocator {
    public static final String WORKFLOW_DOCUMENT_ACTIONS_SERVICE = "rice.kew.workflowDocumentActionsService";
    public static final String WORKFLOW_DOCUMENT_SERVICE = "rice.kew.workflowDocumentService";
    public static final String ACTION_LIST_SERVICE = "rice.kew.actionListService";
    public static final String DOCUMENT_TYPE_SERVICE = "rice.kew.documentTypeService";
    public static final String NOTE_SERVICE = "rice.kew.noteService";
    public static final String EXTENSION_REPOSITORY_SERVICE = "rice.kew.extensionRepositoryService";
    public static final String RULE_SERVICE = "rice.kew.ruleService";
    public static final String KEW_TYPE_REPOSITORY_SERVICE = "rice.kew.kewTypeRepositoryService";
    public static final String PEOPLE_FLOW_SERVICE = "rice.kew.peopleFlowService";
    public static final String PREFERENCES_SERVICE = "rice.kew.preferencesService";
    public static final String KEW_RUN_MODE_PROPERTY = "kew.mode";
    public static final String STANDALONE_APPLICATION_ID = "standalone.application.id";
    public static final QName DOCUMENT_ATTRIBUTE_INDEXING_QUEUE_NAME = new QName("http://rice.kuali.org/kew/v2_0", "documentAttributeIndexingQueue");
    public static final QName GROUP_MEMBERSHIP_CHANGE_QUEUE_NAME = new QName("http://rice.kuali.org/kew/v2_0", "groupMembershipChangeQueue");
    public static final QName IMMEDIATE_EMAIL_REMINDER_QUEUE = new QName("http://rice.kuali.org/kew/v2_0", "immediateEmailReminderQueue");
    public static final QName RESPONSIBILITY_CHANGE_QUEUE = new QName("http://rice.kuali.org/kew/v2_0", "responsibilityChangeQueue");
    public static final QName DOCUMENT_REFRESH_QUEUE = new QName("http://rice.kuali.org/kew/v2_0", "documentRefreshQueue");
    public static final QName ROLE_POKER_QUEUE = new QName("http://rice.kuali.org/kew/v2_0", "rolePokerQueue");
    public static final QName DOCUMENT_PROCESSING_QUEUE = new QName("http://rice.kuali.org/kew/v2_0", "documentProcessingQueue");
    public static final QName DOCUMENT_ORCHESTRATION_QUEUE = new QName("http://rice.kuali.org/kew/v2_0", "documentOrchestrationQueue");
    public static final QName ACTION_INVOCATION_QUEUE = new QName("http://rice.kuali.org/kew/v2_0", "actionInvocationQueue");

    static <T> T getService(String serviceName) {
        return (T)GlobalResourceLoader.getService((String)serviceName);
    }

    public static WorkflowDocumentActionsService getWorkflowDocumentActionsService() {
        RunMode kewRunMode = RunMode.valueOf((String)ConfigContext.getCurrentContextConfig().getProperty(KEW_RUN_MODE_PROPERTY));
        if (kewRunMode == RunMode.REMOTE || kewRunMode == RunMode.THIN) {
            String standaloneApplicationId = ConfigContext.getCurrentContextConfig().getProperty(STANDALONE_APPLICATION_ID);
            return KewApiServiceLocator.getWorkflowDocumentActionsService(standaloneApplicationId);
        }
        return (WorkflowDocumentActionsService)KewApiServiceLocator.getService(WORKFLOW_DOCUMENT_ACTIONS_SERVICE);
    }

    public static WorkflowDocumentActionsService getWorkflowDocumentActionsService(String applicationId) {
        if (!StringUtils.isEmpty((String)applicationId)) {
            QName qN = new QName("http://rice.kuali.org/kew/v2_0", "workflowDocumentActionsService");
            return (WorkflowDocumentActionsService)KsbApiServiceLocator.getServiceBus().getService(qN, applicationId);
        }
        return KewApiServiceLocator.getWorkflowDocumentActionsService();
    }

    public static WorkflowDocumentService getWorkflowDocumentService() {
        return (WorkflowDocumentService)KewApiServiceLocator.getService(WORKFLOW_DOCUMENT_SERVICE);
    }

    public static ActionListService getActionListService() {
        return (ActionListService)KewApiServiceLocator.getService(ACTION_LIST_SERVICE);
    }

    public static DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KewApiServiceLocator.getService(DOCUMENT_TYPE_SERVICE);
    }

    public static NoteService getNoteService() {
        return (NoteService)KewApiServiceLocator.getService(NOTE_SERVICE);
    }

    public static RuleService getRuleService() {
        return (RuleService)KewApiServiceLocator.getService(RULE_SERVICE);
    }

    public static ExtensionRepositoryService getExtensionRepositoryService() {
        return (ExtensionRepositoryService)KewApiServiceLocator.getService(EXTENSION_REPOSITORY_SERVICE);
    }

    public static KewTypeRepositoryService getKewTypeRepositoryService() {
        return (KewTypeRepositoryService)KewApiServiceLocator.getService(KEW_TYPE_REPOSITORY_SERVICE);
    }

    public static PeopleFlowService getPeopleFlowService() {
        return (PeopleFlowService)KewApiServiceLocator.getService(PEOPLE_FLOW_SERVICE);
    }

    public static DocumentAttributeIndexingQueue getDocumentAttributeIndexingQueue() {
        return KewApiServiceLocator.getDocumentAttributeIndexingQueue(null);
    }

    public static DocumentAttributeIndexingQueue getDocumentAttributeIndexingQueue(String applicationId) {
        return (DocumentAttributeIndexingQueue)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(DOCUMENT_ATTRIBUTE_INDEXING_QUEUE_NAME, applicationId);
    }

    public static GroupMembershipChangeQueue getGroupMembershipChangeQueue() {
        return (GroupMembershipChangeQueue)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(GROUP_MEMBERSHIP_CHANGE_QUEUE_NAME);
    }

    public static ResponsibilityChangeQueue getResponsibilityChangeQueue() {
        return (ResponsibilityChangeQueue)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(RESPONSIBILITY_CHANGE_QUEUE);
    }

    public static ImmediateEmailReminderQueue getImmediateEmailReminderQueue() {
        return (ImmediateEmailReminderQueue)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(IMMEDIATE_EMAIL_REMINDER_QUEUE);
    }

    public static PreferencesService getPreferencesService() {
        return (PreferencesService)KewApiServiceLocator.getService(PREFERENCES_SERVICE);
    }

    public static DocumentProcessingQueue getDocumentProcessingQueue(String documentId, String applicationId) {
        return (DocumentProcessingQueue)KewApiServiceLocator.getServiceAsynchronously(DOCUMENT_PROCESSING_QUEUE, documentId, applicationId);
    }

    public static ActionInvocationQueue getActionInvocationProcessorService(String documentId, String applicationId) {
        return (ActionInvocationQueue)KewApiServiceLocator.getServiceAsynchronously(ACTION_INVOCATION_QUEUE, documentId, applicationId);
    }

    public static DocumentOrchestrationQueue getDocumentOrchestrationQueue(String documentId, String applicationId) {
        return (DocumentOrchestrationQueue)KewApiServiceLocator.getServiceAsynchronously(DOCUMENT_ORCHESTRATION_QUEUE, documentId, applicationId);
    }

    public static RolePokerQueue getRolePokerQueue(String documentId, String applicationId) {
        return (RolePokerQueue)KewApiServiceLocator.getServiceAsynchronously(ROLE_POKER_QUEUE, documentId, applicationId);
    }

    public static DocumentRefreshQueue getDocumentRequeuerService(String applicationId, String documentId, long waitTime) {
        if (waitTime > 0L) {
            return (DocumentRefreshQueue)KewApiServiceLocator.getDelayedServiceAsynchronously(DOCUMENT_REFRESH_QUEUE, documentId, waitTime, applicationId);
        }
        return (DocumentRefreshQueue)KewApiServiceLocator.getServiceAsynchronously(DOCUMENT_REFRESH_QUEUE, documentId, applicationId);
    }

    private static Object getDelayedServiceAsynchronously(QName serviceName, String documentId, long waitTime, String applicationId) {
        return KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, applicationId, null, documentId == null ? null : documentId.toString(), null, waitTime);
    }

    private static Object getServiceAsynchronously(QName serviceName, String documentId, String applicationId) {
        return KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, applicationId, null, null, documentId == null ? null : documentId.toString(), null);
    }
}

