/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;

public class IrbAcknowledgementUnavailableAuthorizer
extends ProtocolAuthorizer {
    @Override
    public boolean isAuthorized(String userId, ProtocolTask task) {
        return !this.isValidToPerform(task) && this.hasPermission(userId, task.getProtocol(), "Perform IRB Actions on a Protocol");
    }

    private boolean isValidToPerform(ProtocolTask task) {
        boolean isValid = false;
        Protocol protocol = task.getProtocol();
        if (protocol.getNotifyIrbSubmissionId() != null) {
            for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
                if (!submission.getSubmissionId().equals(protocol.getNotifyIrbSubmissionId())) continue;
                isValid = this.isValidFYI((ProtocolSubmission)submission);
            }
        }
        if (!isValid) {
            protocol.setNotifyIrbSubmissionId(null);
            isValid = this.canExecuteAction(task.getProtocol(), "209");
        }
        return isValid;
    }

    private boolean isValidFYI(ProtocolSubmission submission) {
        return this.isFYISubmission(submission.getSubmissionTypeCode()) && this.isFYIReview(submission.getProtocolReviewTypeCode()) && this.isStatusValid(submission.getSubmissionStatusCode());
    }

    private boolean isFYISubmission(String submissionTypeCode) {
        return StringUtils.isNotBlank((CharSequence)submissionTypeCode) && "112".equals(submissionTypeCode);
    }

    private boolean isFYIReview(String reviewTypeCode) {
        return StringUtils.isNotBlank((CharSequence)reviewTypeCode);
    }

    private boolean isStatusValid(String submissionStatusCode) {
        return StringUtils.isNotBlank((CharSequence)submissionStatusCode) && ("100".equals(submissionStatusCode) || "101".equals(submissionStatusCode));
    }
}

