/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.util.HashMap;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PlatformFactory {
    private static HashMap platforms = new HashMap();

    public static Platform getPlatformFor(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        String string = jdbcConnectionDescriptor.getDbms();
        Platform platform = null;
        String string2 = null;
        platform = (Platform)PlatformFactory.getPlatforms().get(string);
        if (platform == null) {
            try {
                string2 = PlatformFactory.getClassnameFor(string);
                Class clazz = ClassHelper.getClass(string2);
                platform = (Platform)clazz.newInstance();
            }
            catch (Throwable throwable) {
                LoggerFactory.getDefaultLogger().warn("[PlatformFactory] problems with platform " + string2, throwable);
                LoggerFactory.getDefaultLogger().warn("[PlatformFactory] OJB will use PlatformDefaultImpl instead");
                platform = new PlatformDefaultImpl();
            }
            PlatformFactory.getPlatforms().put(string, platform);
        }
        return platform;
    }

    private static String getClassnameFor(String string) {
        String string2 = "Default";
        if (string != null) {
            string2 = string;
        }
        return "org.apache.ojb.broker.platforms.Platform" + string2.substring(0, 1).toUpperCase() + string2.substring(1) + "Impl";
    }

    private static HashMap getPlatforms() {
        return platforms;
    }
}

