/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.costshare;

import java.util.List;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.framework.costshare.CostShareService;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.rice.krad.util.AuditError;

public abstract class CostShareRuleResearchDocumentBase
extends KcTransactionalDocumentRuleBase {
    private CostShareService costShareService;
    private transient UnitService unitService;

    protected boolean validateProjectPeriod(Object projectPeriod, String projectPeriodField, int numberOfProjectPeriods) {
        boolean valid = true;
        if (projectPeriod != null) {
            try {
                int projectPeriodInt = Integer.parseInt(projectPeriod.toString().trim());
                if (this.validateAsFiscalYear()) {
                    if (projectPeriodInt < Constants.MIN_FISCAL_YEAR || projectPeriodInt > Constants.MAX_FISCAL_YEAR) {
                        valid = false;
                        this.reportError(projectPeriodField, "error.awardCostShare.fiscalYear.range", this.getProjectPeriodLabel());
                    }
                } else if (this.validateAsProjectPeriod() && numberOfProjectPeriods > -1 && projectPeriodInt <= 0) {
                    valid = false;
                    String[] params = new String[]{this.getProjectPeriodLabel(), String.valueOf(numberOfProjectPeriods)};
                    this.reportError(projectPeriodField, "error.awardCostShare.projectPeriod.range", params);
                }
            }
            catch (NumberFormatException e) {
                valid = false;
                this.reportError(projectPeriodField, "error.fiscalYear.IncorrectFormat", this.getProjectPeriodLabel());
            }
        } else {
            valid = false;
            this.reportError(projectPeriodField, "error.awardCostShare.fiscalYear.required", this.getProjectPeriodLabel());
        }
        return valid;
    }

    public boolean validateProjectPeriod(Object projectPeriod, String projectPeriodField) {
        return this.validateProjectPeriod(projectPeriod, projectPeriodField, -1);
    }

    public boolean validatePeriodNumber(BudgetCostShare costShare, String projectPeriodField, int numberOfProjectPeriods, List<AuditError> auditErrors) {
        int projectPeriodInt = Integer.parseInt(costShare.getProjectPeriod().toString().trim());
        if (projectPeriodInt <= 0 || projectPeriodInt > numberOfProjectPeriods) {
            AuditError auditError = new AuditError(projectPeriodField, "error.awardCostShare.projectPeriod.range", "budgetDistributionAndIncome.budgetCostSharing", new String[]{Integer.toString(projectPeriodInt), Integer.toString(numberOfProjectPeriods), Integer.toString(numberOfProjectPeriods)});
            auditErrors.add(auditError);
            return false;
        }
        return true;
    }

    protected CostShareService getCostShareService() {
        if (this.costShareService == null) {
            this.costShareService = KcServiceLocator.getService(CostShareService.class);
        }
        return this.costShareService;
    }

    public void setCostShareService(CostShareService costShareService) {
        this.costShareService = costShareService;
    }

    private String getProjectPeriodLabel() {
        String label = this.getCostShareService().getCostShareLabel();
        return label;
    }

    private boolean validateAsFiscalYear() {
        boolean retVal = this.getCostShareService().validateProjectPeriodAsFiscalYear();
        return retVal;
    }

    private boolean validateAsProjectPeriod() {
        boolean retVal = this.getCostShareService().validateProjectPeriodAsProjectPeriod();
        return retVal;
    }

    public boolean validateUnit(String unitNumber, String field) {
        if (unitNumber != null && this.getUnitService().getActiveUnit(unitNumber) == null) {
            this.reportWarning(field, "error.award.unitNumber", unitNumber);
        }
        return true;
    }

    protected UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }
}

