/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.web.krad.KcBindingInfo;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowDelegateBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowMemberBo;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.control.UserControl;
import org.kuali.rice.krad.uif.field.InputFieldBase;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.widget.QuickFinder;

public class PeopleFlowMemberInputField
extends InputFieldBase {
    public static final String PERSON_NAME = "person.name";
    public static final String NAME = "Name";

    public void performApplyModel(Object model, LifecycleElement parent) {
        String memberTypeCode = this.getMemberTypeCodeFromModel(model);
        if (StringUtils.equals((CharSequence)memberTypeCode, (CharSequence)MemberType.PRINCIPAL.getCode())) {
            this.setUserControl();
        } else {
            this.setTextControl();
            this.setQuickFinder(memberTypeCode);
        }
        super.performApplyModel(model, parent);
    }

    protected String getMemberTypeCodeFromModel(Object model) {
        Object bo = ObjectPropertyUtils.getPropertyValue((Object)model, (String)KcBindingInfo.getParentBindingInfo(this.getBindingInfo()));
        if (bo instanceof PeopleFlowMemberBo) {
            return ((PeopleFlowMemberBo)bo).getMemberTypeCode();
        }
        if (bo instanceof PeopleFlowDelegateBo) {
            return ((PeopleFlowDelegateBo)bo).getMemberTypeCode();
        }
        return null;
    }

    protected void setQuickFinder(String memberTypeCode) {
        QuickFinder quickFinder = ComponentFactory.getQuickFinder();
        quickFinder.setFieldConversions(Collections.singletonMap("id", "memberId"));
        this.setQuickfinder(quickFinder);
        if (StringUtils.equals((CharSequence)memberTypeCode, (CharSequence)MemberType.ROLE.getCode())) {
            this.getQuickfinder().setDataObjectClassName(RoleBo.class.getName());
        } else if (StringUtils.equals((CharSequence)memberTypeCode, (CharSequence)MemberType.GROUP.getCode())) {
            this.getQuickfinder().setDataObjectClassName(GroupBo.class.getName());
        }
    }

    protected void setTextControl() {
        TextControl textControl = ComponentFactory.getTextControl();
        textControl.setSize(40);
        textControl.setAdditionalCssClasses((List)new ArrayList<String>(){
            {
                this.add("ignoreValid");
            }
        });
        this.setControl((Control)textControl);
    }

    protected void setUserControl() {
        UserControl userControl = ComponentFactory.getUserControl();
        userControl.setPrincipalIdPropertyName("memberId");
        userControl.setPersonNamePropertyName(PERSON_NAME);
        userControl.setWatermarkText(NAME);
        userControl.setAdditionalCssClasses((List)new ArrayList<String>(){
            {
                this.add("ignoreValid");
            }
        });
        this.setControl((Control)userControl);
    }
}

