/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.notification;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.notification.IRBNotificationRenderer;

public class NotifyCommitteeNotificationRenderer
extends IRBNotificationRenderer {
    private static final long serialVersionUID = -5315801471642797815L;
    private String committeeName;
    private String actionComments;
    private Date actionDate;

    public NotifyCommitteeNotificationRenderer(Protocol protocol, String committeeName, String actionComments, Date actionDate) {
        super(protocol);
        this.actionDate = actionDate;
        this.actionComments = actionComments;
        this.committeeName = committeeName;
    }

    public String getActionComments() {
        return this.actionComments;
    }

    public Date getActionDate() {
        return this.actionDate;
    }

    public String getCommitteeName() {
        return this.committeeName;
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        Map<String, String> params = super.getDefaultReplacementParameters();
        params.put("{COMMITTEE_NAME}", this.getSafeMessage("{COMMITTEE_NAME}", this.getCommitteeName()));
        params.put("{ACTION_COMMENTS}", StringUtils.isBlank((CharSequence)this.getActionComments()) ? "None" : this.getActionComments());
        params.put("{ACTION_DATE}", new SimpleDateFormat("d'-'MMM'-'yyyy").format(this.getActionDate()));
        return params;
    }
}

