--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

DELIMITER /
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Root Award for testing Sync Descendants','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Root.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Root.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Root.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '1'),'001002-00001',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Node 2 Award for testing Sync Descendants','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '1'),'001002-00002',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Node 3 Award for testing Sync Descendants','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 3.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 3.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 3.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '1'),'001002-00003',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Copied Award','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '1'),'001002-00004',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Node 4 Award for testing Sync Descendants','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 4.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 4.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 4.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '2'),'001002-00004',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Node 5 Award for testing Sync Descendants','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 5.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 5.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 5.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '1'),'001002-00005',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Copied Award','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '1'),'001002-00006',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Copied Award','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 3.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 3.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 3.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '1'),'001002-00007',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Copied Award','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 4.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 4.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 4.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '1'),'001002-00008',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Node 6 Award for testing Sync Descendants','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 6.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 6.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 6.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '2'),'001002-00006',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Node 7 Award for testing Sync Descendants','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 7.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 7.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 7.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '2'),'001002-00007',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 8.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 8.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Node 8 Award for testing Sync Descendants','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 8.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 8.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 8.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 8.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 8.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 8.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 8.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 8.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00008' AND SEQUENCE_NUMBER = '2'),'001002-00008',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 8.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Node 9 Award for testing Sync Descendants','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 9.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 9.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 9.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '1'),'001002-00009',1,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Test 1: Change Sponsor to 000340:NIH for ALL children: FE=Y, CS=N','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Root.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Root.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Root.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '2'),'001002-00001',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Synchronize Descendants from Award 010002-00001','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 2.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00002' AND SEQUENCE_NUMBER = '2'),'001002-00002',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 2.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Synchronize Descendants from Award 010002-00001','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 9.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 9.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 9.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00009' AND SEQUENCE_NUMBER = '2'),'001002-00009',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 9.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Synchronize Descendants from Award 010002-00001','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 3.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 3.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 3.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00003' AND SEQUENCE_NUMBER = '2'),'001002-00003',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 3.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Synchronize Descendants from Award 010002-00001','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 4.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 4.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 4.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00004' AND SEQUENCE_NUMBER = '3'),'001002-00004',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 4.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Synchronize Descendants from Award 010002-00001','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 5.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 5.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 5.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00005' AND SEQUENCE_NUMBER = '2'),'001002-00005',2,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 5.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Synchronize Descendants from Award 010002-00001','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 6.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 6.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 6.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00006' AND SEQUENCE_NUMBER = '3'),'001002-00006',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 6.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'),'Synchronize Descendants from Award 010002-00001','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Node 7.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Node 7.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Node 7.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00007' AND SEQUENCE_NUMBER = '3'),'001002-00007',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Node 7.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'General Comments'),'General remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Fiscal Report Comments'),'Financial Rpt remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Intellectual Property Comments'),'IP remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Procurement Comments'),'Procurement remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Property Comments'),'Property/Equipment remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Invoice Instructions'),'Invoicing remarks from sync to Test Sponsor Template in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Current Action Comments'), '','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Cost Sharing Comments'),'CS comment in Root.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Indirect Cost Comments'),'F&A Comment in Root.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Benefits Rates Comments'),'Benefits comment in Root.','Y','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Sponsor Auth Comments '),'Spon Auth comment in Root.','N','quickstart',NOW(),UUID(),0)
/
INSERT INTO SEQ_AWARD_COMMENT_ID VALUES(NULL)
/
INSERT INTO AWARD_COMMENT (AWARD_COMMENT_ID,AWARD_ID,AWARD_NUMBER,SEQUENCE_NUMBER,COMMENT_TYPE_CODE,COMMENTS,CHECKLIST_PRINT_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_COMMENT_ID),(SELECT AWARD_ID FROM AWARD WHERE AWARD_NUMBER = '001002-00001' AND SEQUENCE_NUMBER = '3'),'001002-00001',3,(SELECT COMMENT_TYPE_CODE FROM COMMENT_TYPE WHERE DESCRIPTION = 'Pre-Award Institutional Auth Comments'),'Inst Auth comment in Root.','N','quickstart',NOW(),UUID(),0)
/
DELIMITER ;
