/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.reflect.BaseTargetedInvocationHandler;

public class ContextClassLoaderProxy
extends BaseTargetedInvocationHandler<Object> {
    private static final Logger LOG = LogManager.getLogger(ContextClassLoaderProxy.class);
    private ClassLoader classLoader;

    public static Object wrap(Object proxiedObject, Class<?>[] classesToProxy, ClassLoader proxyClassLoader, ClassLoader objectClassLoader) {
        if (proxiedObject == null) {
            return null;
        }
        if (proxyClassLoader == null) {
            proxyClassLoader = proxiedObject.getClass().getClassLoader();
        }
        if (objectClassLoader == null) {
            objectClassLoader = proxiedObject.getClass().getClassLoader();
        }
        if (classesToProxy == null) {
            classesToProxy = ContextClassLoaderProxy.getInterfacesToProxy(proxyClassLoader, proxiedObject);
        }
        ContextClassLoaderProxy handler = new ContextClassLoaderProxy(objectClassLoader, proxiedObject);
        LOG.debug("Installed a ContextClassLoaderProxy on object: " + proxiedObject.getClass().getName());
        proxiedObject = Proxy.newProxyInstance(proxyClassLoader, classesToProxy, (InvocationHandler)handler);
        return proxiedObject;
    }

    public static Object wrap(Object proxiedObject, ClassLoader proxyClassLoader, ClassLoader objectClassLoader) {
        return ContextClassLoaderProxy.wrap(proxiedObject, null, proxyClassLoader, objectClassLoader);
    }

    public static Object wrap(Object proxiedObject, ClassLoader classLoader) {
        return ContextClassLoaderProxy.wrap(proxiedObject, classLoader, classLoader);
    }

    public static Object wrap(Object proxiedObject, Class<?>[] classesToProxy) {
        return ContextClassLoaderProxy.wrap(proxiedObject, classesToProxy, null, null);
    }

    public static Object wrap(Object proxiedObject, Class<?>[] classesToProxy, ClassLoader classLoader) {
        return ContextClassLoaderProxy.wrap(proxiedObject, classesToProxy, classLoader, classLoader);
    }

    public static Object wrap(Object proxiedObject) {
        return ContextClassLoaderProxy.wrap(proxiedObject, null, null, null);
    }

    public static Class<?>[] getInterfacesToProxy(Object proxiedObject) {
        return ContextClassLoaderProxy.getInterfacesToProxy(null, proxiedObject);
    }

    public static Class<?>[] getInterfacesToProxy(ClassLoader proxyClassLoader, Object proxiedObject) {
        return ClassLoaderUtils.getInterfacesToProxy(proxiedObject, proxyClassLoader, null);
    }

    public ContextClassLoaderProxy(ClassLoader classLoader, Object target) {
        super(target);
        this.classLoader = classLoader;
    }

    @Override
    protected Object invokeInternal(Object proxy, Method m, Object[] args) throws Throwable {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = m.invoke(this.getTarget(), args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause() != null ? e.getCause() : e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

