/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notification.service.impl;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.actionitem.ActionItemComparator;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.mail.ImmediateEmailReminderQueue;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.notification.service.NotificationService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class DefaultNotificationService
implements NotificationService {
    private static final String DEFAULT_NOTIFICATION_SERVICE_ASYNC_EMAIL = "DefaultNotificationService_Async_Email";
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private static final Comparator notificationPriorityComparator = ComparatorUtils.reversedComparator((Comparator)new ActionItemComparator());
    private ParameterService parameterService;

    @Override
    public void notify(List<ActionItem> actionItems) {
        actionItems.sort(notificationPriorityComparator);
        HashSet<String> sentNotifications = new HashSet<String>();
        for (ActionItem actionItem : actionItems) {
            if (sentNotifications.contains(actionItem.getPrincipalId()) || !this.shouldNotify(actionItem)) continue;
            sentNotifications.add(actionItem.getPrincipalId());
            this.sendNotification(actionItem);
        }
    }

    protected void sendNotification(ActionItem actionItem) {
        boolean doNotSend = RouteContext.getCurrentRouteContext().isDoNotSendApproveNotificationEmails();
        if (this.parameterService.getParameterValueAsBoolean("KR-WKFLW", "All", DEFAULT_NOTIFICATION_SERVICE_ASYNC_EMAIL).booleanValue()) {
            ImmediateEmailReminderQueue immediateEmailQueue = KewApiServiceLocator.getImmediateEmailReminderQueue();
            immediateEmailQueue.sendReminder(actionItem, Boolean.valueOf(doNotSend));
        } else {
            KEWServiceLocator.getActionListEmailService().sendImmediateReminder(actionItem, doNotSend);
        }
    }

    protected boolean shouldNotify(ActionItem actionItem) {
        try {
            boolean sendEmail = true;
            if (this.isItemOriginatingFromSave(actionItem) && !this.shouldNotifyOnSave(actionItem)) {
                sendEmail = false;
            }
            return sendEmail;
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Error loading user with workflow id " + actionItem.getPrincipalId() + " for notification.", (Throwable)e);
        }
    }

    protected boolean isItemOriginatingFromSave(ActionItem actionItem) {
        return actionItem.getResponsibilityId() != null && actionItem.getResponsibilityId().equals("-3");
    }

    protected boolean shouldNotifyOnSave(ActionItem actionItem) {
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(actionItem.getDocumentId());
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findById(document.getDocumentTypeId());
        return documentType.getNotifyOnSavePolicy().getPolicyValue();
    }

    @Override
    public void removeNotification(List<ActionItem> actionItems) {
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

