/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.collections;

import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.collections.IRemovalAwareCollection;
import org.apache.ojb.broker.util.collections.ManageableArrayList;

public class RemovalAwareList
extends ManageableArrayList
implements IRemovalAwareCollection {
    private Vector allObjectsToBeRemoved = new Vector();

    @Override
    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.allObjectsToBeRemoved.removeAll(this);
        Iterator iterator = this.allObjectsToBeRemoved.iterator();
        while (iterator.hasNext()) {
            persistenceBroker.delete(iterator.next());
        }
        this.allObjectsToBeRemoved.clear();
    }

    @Override
    public Object remove(int n) {
        Object e = super.remove(n);
        this.registerForDeletion(e);
        return e;
    }

    protected void registerForDeletion(Object object) {
        if (!this.allObjectsToBeRemoved.contains(object)) {
            this.allObjectsToBeRemoved.add(object);
        }
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        this.registerForDeletion(object);
        return bl;
    }

    public synchronized void removeAllElements() {
        for (int i = 0; i < this.size(); ++i) {
            this.registerForDeletion(this.get(i));
        }
        super.clear();
    }

    public synchronized void removeElementAt(int n) {
        Object e = this.get(n);
        this.registerForDeletion(e);
        super.remove(n);
    }

    @Override
    public synchronized void clear() {
        this.removeAllElements();
    }

    @Override
    protected void removeRange(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.registerForDeletion(this.get(i));
        }
        super.removeRange(n, n2);
    }

    public void resetDeleted() {
        this.allObjectsToBeRemoved.clear();
    }
}

