/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.copy;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.ConstructorHelper;
import org.apache.ojb.broker.util.IdentityMapFactory;
import org.apache.ojb.otm.copy.ObjectCopyException;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.copy.ReflectiveObjectCopyStrategy;
import org.apache.ojb.otm.copy.SerializeObjectCopyStrategy;

public final class MetadataObjectCopyStrategy
implements ObjectCopyStrategy {
    private static final ReflectiveObjectCopyStrategy _reflective = new ReflectiveObjectCopyStrategy();
    private static final SerializeObjectCopyStrategy _serialize = new SerializeObjectCopyStrategy();

    @Override
    public Object copy(Object object, PersistenceBroker persistenceBroker) {
        return MetadataObjectCopyStrategy.clone(object, IdentityMapFactory.getIdentityMap(), persistenceBroker);
    }

    private static Object clone(Object object, Map map, PersistenceBroker persistenceBroker) {
        Object object2;
        Object object3;
        Iterator iterator;
        ObjectReferenceDescriptor[] objectReferenceDescriptorArray;
        Object object4;
        FieldDescriptor[] fieldDescriptorArray;
        if (map.containsKey(object)) {
            return map.get(object);
        }
        if (object == null) {
            return null;
        }
        if (ProxyHelper.isVirtualOjbProxy(object)) {
            return _reflective.copy(object, null);
        }
        if (ProxyHelper.isNormalOjbProxy(object)) {
            return _serialize.copy(object, null);
        }
        ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
        if (classDescriptor == null) {
            return _reflective.copy(object, null);
        }
        try {
            fieldDescriptorArray = classDescriptor.getZeroArgumentConstructor();
            object4 = ConstructorHelper.instantiate((Constructor)fieldDescriptorArray);
            map.put(object, object4);
        }
        catch (InstantiationException instantiationException) {
            throw new ObjectCopyException("InstantiationException", instantiationException);
        }
        fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            objectReferenceDescriptorArray = fieldDescriptorArray[i];
            PersistentField persistentField = objectReferenceDescriptorArray.getPersistentField();
            iterator = persistentField.get(object);
            persistentField.set(object4, iterator);
        }
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        objectReferenceDescriptorArray = vector.toArray(new ObjectReferenceDescriptor[vector.size()]);
        for (int i = 0; i < objectReferenceDescriptorArray.length; ++i) {
            iterator = objectReferenceDescriptorArray[i];
            Serializable serializable = ((AttributeDescriptorBase)((Object)iterator)).getPersistentField();
            object3 = serializable.get(object);
            object2 = MetadataObjectCopyStrategy.clone(object3, map, persistenceBroker);
            map.put(object3, object2);
            serializable.set(object4, object2);
        }
        Vector vector2 = classDescriptor.getCollectionDescriptors();
        for (Serializable serializable : vector2) {
            object3 = ((AttributeDescriptorBase)serializable).getPersistentField();
            object2 = object3.get(object);
            if (object2 == null) {
                object3.set(object4, null);
                continue;
            }
            if (object2 instanceof CollectionProxyDefaultImpl) {
                object3.set(object4, _reflective.copy(object2, null));
                continue;
            }
            if (object2 instanceof Collection) {
                try {
                    Collection collection = (Collection)object2.getClass().newInstance();
                    for (Object e : (Collection)object2) {
                        if (ProxyHelper.isNormalOjbProxy(e)) {
                            collection.add(e);
                            continue;
                        }
                        Object object5 = MetadataObjectCopyStrategy.clone(e, map, persistenceBroker);
                        map.put(e, object5);
                        collection.add(object5);
                    }
                    object3.set(object4, collection);
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    throw new ObjectCopyException("InstantiationException", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ObjectCopyException("IllegalAccessException", illegalAccessException);
                }
            }
            throw new UnsupportedOperationException("MetadataObjectCopyStrategy cannot handle Collection of type: " + object2.getClass().getName());
        }
        return object4;
    }
}

