/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.InquiryForm;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBoService;
import org.kuali.rice.krms.impl.ui.AgendaEditor;

public class PropositionTypeValuesFinder
extends UifKeyValuesFinderBase {
    public List<KeyValue> getKeyValues(ViewModel model) {
        AgendaEditor agendaEditor;
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        if (model instanceof InquiryForm) {
            InquiryForm inquiryForm = (InquiryForm)model;
            agendaEditor = (AgendaEditor)inquiryForm.getDataObject();
        } else {
            MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)model;
            agendaEditor = (AgendaEditor)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject();
        }
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        List<TypeTypeRelation> typeRelations = this.getTypeTypeRelationBoService().findTypeTypeRelationsByFromType(rule.getTypeId());
        for (TypeTypeRelation typeRelation : typeRelations) {
            keyValues.add((KeyValue)new ConcreteKeyValue(typeRelation.getToTypeId(), this.getKrmsTypeRepositoryService().getTypeById(typeRelation.getToTypeId()).getName()));
        }
        return keyValues;
    }

    public KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        return KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
    }

    public TypeTypeRelationBoService getTypeTypeRelationBoService() {
        return KrmsRepositoryServiceLocator.getTypeTypeRelationBoService();
    }
}

