/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.DataDictionaryPropertyUtils;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.SupportAttributeDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="relationshipDefinition")
public class RelationshipDefinition
extends DataDictionaryDefinitionBase {
    private static final Logger LOG = LogManager.getLogger(RelationshipDefinition.class);
    private static final long serialVersionUID = 2946722646095412576L;
    protected String objectAttributeName;
    protected Class<?> sourceClass;
    protected Class<?> targetClass;
    protected List<PrimitiveAttributeDefinition> primitiveAttributes = new ArrayList<PrimitiveAttributeDefinition>();
    protected List<SupportAttributeDefinition> supportAttributes = new ArrayList<SupportAttributeDefinition>();

    @BeanTagAttribute(name="objectAttributeName")
    public String getObjectAttributeName() {
        return this.objectAttributeName;
    }

    @BeanTagAttribute(name="sourceClass")
    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    @BeanTagAttribute(name="targetClass")
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void setObjectAttributeName(String objectAttributeName) {
        if (StringUtils.isBlank((String)objectAttributeName)) {
            throw new IllegalArgumentException("invalid (blank) objectAttributeName");
        }
        this.objectAttributeName = objectAttributeName;
    }

    @BeanTagAttribute(name="primitiveAttributes", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<PrimitiveAttributeDefinition> getPrimitiveAttributes() {
        return this.primitiveAttributes;
    }

    @BeanTagAttribute(name="supportAttributes", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<SupportAttributeDefinition> getSupportAttributes() {
        return this.supportAttributes;
    }

    public boolean hasIdentifier() {
        for (SupportAttributeDefinition supportAttributeDefinition : this.supportAttributes) {
            if (!supportAttributeDefinition.isIdentifier()) continue;
            return true;
        }
        return false;
    }

    public SupportAttributeDefinition getIdentifier() {
        for (SupportAttributeDefinition supportAttributeDefinition : this.supportAttributes) {
            if (!supportAttributeDefinition.isIdentifier()) continue;
            return supportAttributeDefinition;
        }
        return null;
    }

    @Override
    public void dataDictionaryPostProcessing() {
        Class propertyClass;
        super.dataDictionaryPostProcessing();
        if (this.targetClass == null && (propertyClass = DataDictionaryPropertyUtils.getAttributeClass(this.sourceClass, this.objectAttributeName)) != null) {
            this.targetClass = propertyClass;
        }
        for (PrimitiveAttributeDefinition primitiveAttributeDefinition : this.primitiveAttributes) {
            primitiveAttributeDefinition.dataDictionaryPostProcessing();
        }
        for (SupportAttributeDefinition supportAttributeDefinition : this.supportAttributes) {
            supportAttributeDefinition.dataDictionaryPostProcessing();
        }
    }

    @Deprecated
    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        this.completeValidation(rootBusinessObjectClass, otherBusinessObjectClass, new ValidationTrace());
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass, ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this.getClass().getSimpleName(), "Attribute: " + this.getObjectAttributeName());
        try {
            if (!DataDictionaryPropertyUtils.isPropertyOf(rootBusinessObjectClass, this.getObjectAttributeName())) {
                currentValues = new String[]{"property = " + this.getObjectAttributeName(), "Class =" + rootBusinessObjectClass};
                tracer.createError("Property is not an attribute of the class", currentValues);
            }
        }
        catch (RuntimeException ex) {
            String[] currentValues2 = new String[]{"attribute = " + this.getObjectAttributeName(), "Exception = " + ex.getMessage()};
            tracer.createError("Unable to validate attribute", currentValues2);
            LOG.error("Exception while validating attribute: " + this.getObjectAttributeName(), (Throwable)ex);
        }
        if (this.targetClass == null) {
            currentValues = new String[]{"property = " + this.getObjectAttributeName(), "sourceClass = " + this.getSourceClass()};
            tracer.createError("Cannot get valid class for property", currentValues);
        } else {
            for (PrimitiveAttributeDefinition primitiveAttributeDefinition : this.primitiveAttributes) {
                primitiveAttributeDefinition.completeValidation(rootBusinessObjectClass, (Class)this.targetClass, tracer.getCopy());
            }
            for (SupportAttributeDefinition supportAttributeDefinition : this.supportAttributes) {
                supportAttributeDefinition.completeValidation(rootBusinessObjectClass, (Class)this.targetClass, tracer.getCopy());
            }
        }
    }

    public void setPrimitiveAttributes(List<PrimitiveAttributeDefinition> primitiveAttributes) {
        this.primitiveAttributes = primitiveAttributes;
    }

    public void setSupportAttributes(List<SupportAttributeDefinition> supportAttributes) {
        this.supportAttributes = supportAttributes;
    }

    public void setSourceClass(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RelationshipDefinition [objectAttributeName=").append(this.objectAttributeName).append(", sourceClass=").append(this.sourceClass).append(", targetClass=").append(this.targetClass).append(", primitiveAttributes=").append(this.primitiveAttributes).append(", supportAttributes=").append(this.supportAttributes).append("]");
        return builder.toString();
    }
}

