/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.rules;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeType;
import org.kuali.coeus.common.committee.impl.bo.MembershipRole;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class MembershipRoleDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        MembershipRole role = (MembershipRole)document.getNewMaintainableObject().getDataObject();
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Delete")) {
            if (document.getNewMaintainableObject().getMaintenanceAction().equals("Edit")) {
                MembershipRole oldDocument = (MembershipRole)document.getOldMaintainableObject().getDataObject();
                if (!StringUtils.equalsIgnoreCase((CharSequence)oldDocument.getCommitteeTypeCode(), (CharSequence)role.getCommitteeTypeCode())) {
                    result &= this.checkExistence(role);
                }
            } else {
                result &= this.checkExistence(role);
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean checkExistence(MembershipRole role) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)role.getCommitteeTypeCode())) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("committeeTypeCode", role.getCommitteeTypeCode());
            CommitteeType committeeType = (CommitteeType)this.getBusinessObjectService().findByPrimaryKey(CommitteeType.class, pkMap);
            if (committeeType == null) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.committeeTypeCode", "error.committeeType.not.exist", new String[]{role.getCommitteeTypeCode()});
                valid = false;
            }
        }
        return valid;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }
}

