/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.person;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.kuali.coeus.common.framework.person.UnitPopulationBehavior;
import org.kuali.coeus.sys.api.model.Coded;
import org.kuali.coeus.sys.api.model.IdentifiableNumeric;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="EPS_PROP_PERSON_ROLE")
public class PropAwardPersonRole
extends KcPersistableBusinessObjectBase
implements ContactRole,
IdentifiableNumeric,
Coded {
    public static final String PRINCIPAL_INVESTIGATOR = "PI";
    public static final String MULTI_PI = "MPI";
    public static final String CO_INVESTIGATOR = "COI";
    public static final String KEY_PERSON = "KP";
    public static final String UNIT_SOURCE_SEPARATOR = ",";
    private static final long serialVersionUID = -2184772940618843909L;
    @PortableSequenceGenerator(name="SEQ_EPS_PROP_PERSON_ROLE")
    @GeneratedValue(generator="SEQ_EPS_PROP_PERSON_ROLE")
    @Id
    @Column(name="PROP_PERSON_ROLE_ID")
    private Long id;
    @Column(name="PROP_PERSON_ROLE_CODE")
    private String code;
    @Column(name="SPONSOR_HIERARCHY_NAME")
    private String sponsorHierarchyName;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="CERTIFICATION_REQUIRED")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean certificationRequired = Boolean.TRUE;
    @Column(name="READ_ONLY_ROLE")
    private Boolean readOnly;
    @Column(name="UNIT_DETAILS_REQUIRED")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean unitDetailsRequired = Boolean.TRUE;
    @Column(name="AUTO_POPULATE_UNITS")
    private String autoPopulateUnitsCode = UnitPopulationBehavior.PRIMARY.getCode();
    @Column(name="SELECTED_UNIT_SOURCES")
    private String selectedUnitSources;

    public final String getCode() {
        return this.code;
    }

    public final void setCode(String argProposalPersonRoleId) {
        this.code = argProposalPersonRoleId;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String argDescription) {
        this.description = argDescription;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getUnitDetailsRequired() {
        return this.unitDetailsRequired;
    }

    public void setUnitDetailsRequired(Boolean unitDetailsRequired) {
        this.unitDetailsRequired = unitDetailsRequired;
    }

    public Boolean getCertificationRequired() {
        return this.certificationRequired;
    }

    public void setCertificationRequired(Boolean certificationRequired) {
        this.certificationRequired = certificationRequired;
    }

    public String getAutoPopulateUnitsCode() {
        return this.autoPopulateUnitsCode;
    }

    public void setAutoPopulateUnitsCode(String autoPopulateUnitsCode) {
        this.autoPopulateUnitsCode = autoPopulateUnitsCode;
    }

    public UnitPopulationBehavior getUnitPopulationBehavior() {
        return UnitPopulationBehavior.fromCode(this.getAutoPopulateUnitsCode());
    }

    public String getSelectedUnitSources() {
        return this.selectedUnitSources;
    }

    public void setSelectedUnitSources(String selectedUnitSources) {
        this.selectedUnitSources = selectedUnitSources;
    }

    @Override
    public String getRoleCode() {
        return this.getCode();
    }

    @Override
    public String getRoleDescription() {
        return this.getDescription();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSponsorHierarchyName() {
        return this.sponsorHierarchyName;
    }

    public void setSponsorHierarchyName(String sponsorHierarchyName) {
        this.sponsorHierarchyName = sponsorHierarchyName;
    }
}

