/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.scheduling;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.coeus.sys.framework.scheduling.ScheduleService;
import org.kuali.coeus.sys.framework.scheduling.expr.CronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.DayCronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.MonthDayCronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.MonthDayOrLastDayMultipleYearsCronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.MonthlyWeekDayCronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.NeverCronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.WeekCronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.YearMonthDayCronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.YearMonthDayOfWeekCronExpression;
import org.kuali.coeus.sys.framework.scheduling.seq.DefaultScheduleSequence;
import org.kuali.coeus.sys.framework.scheduling.seq.ScheduleSequence;
import org.kuali.coeus.sys.framework.scheduling.seq.TrimDatesScheduleSequenceDecorator;
import org.kuali.coeus.sys.framework.scheduling.util.CronSpecialChars;
import org.kuali.coeus.sys.framework.scheduling.util.Time24HrFmt;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.OperableTrigger;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="scheduleService")
@Transactional
public class ScheduleServiceImpl
implements ScheduleService {
    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, ScheduleSequence scheduleSequence) throws ParseException {
        NeverCronExpression expr = new NeverCronExpression(startDate, time);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, Integer frequencyInDay, ScheduleSequence scheduleSequence) throws ParseException {
        DayCronExpression expr = new DayCronExpression(startDate, time, frequencyInDay);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, CronSpecialChars[] weekdays, ScheduleSequence scheduleSequence) throws ParseException {
        WeekCronExpression expr = new WeekCronExpression(startDate, time, weekdays);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, Integer day, Integer frequencyInMonth, ScheduleSequence scheduleSequence) throws ParseException {
        MonthDayCronExpression expr = new MonthDayCronExpression(startDate, time, day, frequencyInMonth);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, ScheduleSequence scheduleSequence, Integer dayOfMonth) throws ParseException {
        MonthDayOrLastDayMultipleYearsCronExpression expr = new MonthDayOrLastDayMultipleYearsCronExpression(startDate, time, dayOfMonth);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, CronSpecialChars dayOfWeek, CronSpecialChars weekOfMonth, Integer frequencyInMonth, ScheduleSequence scheduleSequence) throws ParseException {
        MonthlyWeekDayCronExpression expr = new MonthlyWeekDayCronExpression(startDate, time, dayOfWeek, weekOfMonth, frequencyInMonth);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, CronSpecialChars month, Integer day, Integer frequencyInYear, ScheduleSequence scheduleSequence) throws ParseException {
        YearMonthDayCronExpression expr = new YearMonthDayCronExpression(startDate, time, month, day, frequencyInYear);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, CronSpecialChars weekOfMonth, CronSpecialChars dayOfWeek, CronSpecialChars month, Integer frequencyInYear, ScheduleSequence scheduleSequence) throws ParseException {
        YearMonthDayOfWeekCronExpression expr = new YearMonthDayOfWeekCronExpression(startDate, time, weekOfMonth, dayOfWeek, month, frequencyInYear);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    protected List<Date> getScheduledDates(CronExpression expression, Date startDate, Date endDate, Time24HrFmt time, ScheduleSequence scheduleSequence) throws ParseException {
        scheduleSequence = this.getScheduleSequence(scheduleSequence);
        startDate = this.wrapTime(startDate, null);
        endDate = this.wrapTime(endDate, time);
        return scheduleSequence.executeScheduleSequence(expression.getExpression(), startDate, endDate);
    }

    protected Date wrapTime(Date date, Time24HrFmt time) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int hour = calendar.get(10);
        int min = calendar.get(12);
        int am_pm = calendar.get(9);
        if (am_pm == 0) {
            date = DateUtils.addHours((Date)date, (int)(-hour));
            date = DateUtils.addMinutes((Date)date, (int)(-min));
        } else {
            date = DateUtils.addHours((Date)date, (int)(-hour - 12));
            date = DateUtils.addMinutes((Date)date, (int)(-min));
        }
        if (null != time) {
            date = DateUtils.addHours((Date)date, (int)new Integer(time.getHours()));
            date = DateUtils.addMinutes((Date)date, (int)new Integer(time.getMinutes()));
        }
        return date;
    }

    protected ScheduleSequence getScheduleSequence(ScheduleSequence scheduleSequence) {
        if (null == scheduleSequence) {
            scheduleSequence = new TrimDatesScheduleSequenceDecorator(new DefaultScheduleSequence());
        }
        return scheduleSequence;
    }

    @Override
    public List<Date> getIntervalInDaysScheduledDates(Date startDate, Date endDate, Time24HrFmt time, Integer intervalInDays) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date triggerStartDate = cal.getTime();
        cal = Calendar.getInstance();
        cal.setTime(endDate);
        cal.set(11, 14);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date triggerEndDate = cal.getTime();
        SimpleTriggerImpl trigger = new SimpleTriggerImpl("myTrigger", "default", triggerStartDate, triggerEndDate, -1, (long)intervalInDays.intValue() * 24L * 60L * 60L * 1000L);
        List dates = TriggerUtils.computeFireTimesBetween((OperableTrigger)trigger, null, (Date)triggerStartDate, (Date)triggerEndDate);
        ArrayList<Date> returnDates = new ArrayList<Date>();
        for (Date date : dates) {
            cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, Integer.valueOf(time.getHours()));
            cal.set(12, Integer.valueOf(time.getMinutes()));
            cal.set(13, 0);
            cal.set(14, 0);
            returnDates.add(cal.getTime());
        }
        return returnDates;
    }
}

