/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.correspondence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionTypeToCorrespondenceTemplateService;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTypeBase;
import org.kuali.kra.protocol.correspondence.ValidProtoActionCoresp;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProtocolActionTypeToCorrespondenceTemplateServiceImplBase
implements ProtocolActionTypeToCorrespondenceTemplateService {
    private BusinessObjectService businessObjectService;

    protected abstract Class<? extends ProtocolCorrespondenceTypeBase> getProtocolCorrespondenceTypeClassHook();

    protected abstract Class<? extends ValidProtoActionCoresp> getProtocolActionCorrespondenceMappingClassHook();

    @Override
    public List<ProtocolCorrespondenceTemplateBase> getTemplatesByProtocolAction(String protocolActionType, String committeeId) {
        ArrayList<ProtocolCorrespondenceTemplateBase> templates = new ArrayList<ProtocolCorrespondenceTemplateBase>();
        Map<String, List<String>> actionTypesToCorrespondenceTypeMap = this.getActionTypesToCorrespondenceTypeMap();
        if (actionTypesToCorrespondenceTypeMap.containsKey(protocolActionType)) {
            for (String correspondenceTypeId : actionTypesToCorrespondenceTypeMap.get(protocolActionType)) {
                templates.addAll(this.getCorrespondenceTemplatesForTypeId(correspondenceTypeId, committeeId));
            }
        }
        return templates;
    }

    @Override
    public List<ProtocolCorrespondenceTemplateBase> getTemplatesByProtocolAction(String protocolActionType) {
        return this.getTemplatesByProtocolAction(protocolActionType, "DEFAULT");
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected Map<String, List<String>> getActionTypesToCorrespondenceTypeMap() {
        HashMap<String, List<String>> actionTypesToCorrespondenceType = new HashMap<String, List<String>>();
        List<ValidProtoActionCoresp> validCorrespTypes = this.getValidProtocolActionCorrespondence();
        for (ValidProtoActionCoresp validProtoActionCorresp : validCorrespTypes) {
            String protocolActionTypeCode = validProtoActionCorresp.getProtocolActionTypeCode();
            ArrayList<String> actionCorresps = (ArrayList<String>)actionTypesToCorrespondenceType.get(protocolActionTypeCode);
            if (actionCorresps == null) {
                actionCorresps = new ArrayList<String>();
            }
            actionCorresps.add(validProtoActionCorresp.getProtoCorrespTypeCode());
            actionTypesToCorrespondenceType.put(protocolActionTypeCode, actionCorresps);
        }
        return actionTypesToCorrespondenceType;
    }

    protected List<ValidProtoActionCoresp> getValidProtocolActionCorrespondence() {
        return (List)this.getBusinessObjectService().findAll(this.getProtocolActionCorrespondenceMappingClassHook());
    }

    protected List<ProtocolCorrespondenceTemplateBase> getCorrespondenceTemplatesForTypeId(String correspondenceTypeId, String committeeId) {
        ProtocolCorrespondenceTypeBase type = (ProtocolCorrespondenceTypeBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getProtocolCorrespondenceTypeClassHook(), (Object)correspondenceTypeId);
        if (type != null) {
            List<ProtocolCorrespondenceTemplateBase> committeeTemplates = type.getCommitteeProtocolCorrespondenceTemplates(committeeId);
            return committeeTemplates.isEmpty() ? type.getProtocolCorrespondenceTemplates() : committeeTemplates;
        }
        return new ArrayList<ProtocolCorrespondenceTemplateBase>();
    }
}

