/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.correspondence;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.watermark.Watermarkable;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionTypeToCorrespondenceTemplateService;
import org.kuali.kra.protocol.actions.print.CorrespondenceXmlStreamBase;
import org.kuali.kra.protocol.actions.print.ProtocolPrintWatermarkBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;

public abstract class ProtocolActionsCorrespondenceBase
extends AbstractPrint {
    private ProtocolBase protocol;

    public void setProtocol(ProtocolBase protcol) {
        this.protocol = protcol;
    }

    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    @Override
    public KcPersistableBusinessObjectBase getPrintableBusinessObject() {
        return this.getProtocol();
    }

    protected abstract ProtocolActionTypeToCorrespondenceTemplateService getProtocolActionTypeToCorrespondenceTemplateService();

    public abstract String getProtocolActionType();

    private List<ProtocolCorrespondenceTemplateBase> getCorrespondenceTemplates() {
        String committeeId = this.getProtocol().getProtocolSubmission().getCommitteeId();
        List<ProtocolCorrespondenceTemplateBase> templates = this.getProtocolActionTypeToCorrespondenceTemplateService().getTemplatesByProtocolAction(this.getProtocolActionType(), committeeId);
        return templates;
    }

    @Override
    public List<Source> getXSLTemplates() {
        ArrayList<Source> sourceList = new ArrayList<Source>();
        List<ProtocolCorrespondenceTemplateBase> templates = this.getCorrespondenceTemplates();
        for (ProtocolCorrespondenceTemplateBase template : templates) {
            ByteArrayInputStream iputStream = new ByteArrayInputStream(template.getCorrespondenceTemplate());
            StreamSource stream = new StreamSource(iputStream);
            sourceList.add(stream);
        }
        return sourceList;
    }

    public String getProtoCorrespTypeCode() {
        List<ProtocolCorrespondenceTemplateBase> templates = this.getCorrespondenceTemplates();
        Iterator<ProtocolCorrespondenceTemplateBase> iterator = templates.iterator();
        if (iterator.hasNext()) {
            ProtocolCorrespondenceTemplateBase template = iterator.next();
            return template.getProtoCorrespTypeCode();
        }
        return "";
    }

    @Override
    public Map<String, XmlObject> renderXML() throws PrintingException {
        this.setXmlStream(this.getCorrespondenceXmlStream());
        return super.renderXML();
    }

    public abstract CorrespondenceXmlStreamBase getCorrespondenceXmlStream();

    @Override
    public boolean isWatermarkEnabled() {
        return true;
    }

    @Override
    public Watermarkable getWatermarkable() {
        ProtocolPrintWatermarkBase prtocolPrintWatermark = this.getNewProtocolPrintWatermarkInstanceHook();
        prtocolPrintWatermark.setPersistableBusinessObject(this.getPrintableBusinessObject());
        return prtocolPrintWatermark;
    }

    protected abstract ProtocolPrintWatermarkBase getNewProtocolPrintWatermarkInstanceHook();

    public String getLeadUnitNumber() {
        return this.getProtocol().getLeadUnitNumber();
    }

    protected abstract String getAdministratorType();

    protected abstract String getModuleNameSpace();
}

