--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

INSERT INTO SPONSOR_FORM_TEMPLATES (SPONSOR_FORM_TEMPLATE_ID,SPONSOR_FORM_ID,PAGE_NUMBER,PAGE_DESCRIPTION,FILE_NAME,CONTENT_TYPE,FORM_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (SEQ_SPONSOR_FORM_TEMPLATES.NEXTVAL,(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)'),13,'Budget Entire Proposed Period','Budget Entire Proposed Period.xslt','text/xml',EMPTY_CLOB(),'admin',SYSDATE,SYS_GUID(),1);
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := '<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://era.nih.gov/Projectmgmt/SBIR/CGAP/common.namespace" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:nih="http://era.nih.gov/Projectmgmt/SBIR/CGAP/nihspecific.namespace" xmlns:phs398="http://era.nih.gov/Projectmgmt/SBIR/CGAP/phs398.namespace" xmlns:rar="http://era.nih.gov/Projectmgmt/SBIR/CGAP/researchandrelated.namespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
    <xsl:param name="SV_OutputFormat" select="''PDF''"/>
    <xsl:variable name="XML" select="/"/>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
                <fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
                <fo:region-after extent="0.79in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="/">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <xsl:call-template name="footerall"/>
                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                        <xsl:for-each select="$XML">
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table line-height="10pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                <fo:table-column column-width="75"/>
                                <fo:table-column column-width="75"/>
                                <fo:table-column column-width="39"/>
                                <fo:table-column column-width="79"/>
                                <fo:table-column column-width="79"/>
                                <fo:table-column column-width="79"/>
                                <fo:table-column column-width="39"/>
                                <fo:table-column column-width="79"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell border-left-style="none" border-right-style="none" border-top-style="none" number-columns-spanned="8" border="solid 1pt gray" padding="2pt" height="7" text-align="left" display-align="center">
                                            <fo:block>
                                                <fo:inline font-family="Verdana" font-size="smaller">
                                                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:text>Principal Investigator/Program Director (Last, first, middle): </xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="nih:ResearchCoverPage">
                                                        <xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
                                                            <xsl:for-each select="Name">
                                                                <xsl:for-each select="LastName">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-family="Verdana" font-size="9pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-family="Verdana" font-size="9pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
    ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := '                                                         <fo:inline font-family="Verdana" font-size="9pt">
                                                                    <xsl:text>, </xsl:text>
                                                                </fo:inline>
                                                                <xsl:for-each select="FirstName">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-family="Verdana" font-size="9pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-family="Verdana" font-size="9pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                                <fo:inline font-family="Verdana" font-size="9pt">
                                                                    <xsl:text>&#160;</xsl:text>
                                                                </fo:inline>
                                                                <xsl:for-each select="MiddleName">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-family="Verdana" font-size="9pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-family="Verdana" font-size="9pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="8" border="solid 1pt gray" padding="2pt" height="30" text-align="center" display-align="center">
                                            <fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block padding-top="6pt" font-size="xx-small" font-weight="bold" margin="0pt">
                                                    <fo:block>
                                                        <fo:inline font-size="10pt" font-weight="bold">
                                                            <xsl:text>BUDGET FOR ENTIRE PROPOSED PROJECT PERIOD</xsl:text>
                                                        </fo:inline>
                                                        <fo:block/>
                                                        <fo:inline font-size="10pt" font-weight="bold">
                                                            <xsl:text>DIRECT COSTS ONLY</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" number-rows-spanned="2" border="solid 1pt gray" padding="2pt" height="17" text-align="center" display-align="after">
                                            <fo:block>
                                                <fo:inline font-size="9pt">
                                                    <xsl:text>BUDGET CATEGORY </xsl:text>
                                                </fo:inline>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <fo:inline font-size="9pt">
                                                            <xsl:text>TOTALS</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell number-rows-spanned="2" border="solid 1pt gray" padding="2pt" height="17" text-align="center" display-align="center">
                                            <fo:block>
                ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := '                             <fo:inline font-size="8pt">
                                                    <xsl:text>INITIAL BUDGET PERIOD</xsl:text>
                                                </fo:inline>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <fo:inline font-size="8pt">
                                                            <xsl:text> (from Form Page 4)</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell number-columns-spanned="4" border="solid 1pt gray" padding="2pt" height="17" text-align="center" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="9pt">
                                                    <xsl:text>ADDITIONAL YEARS OF SUPPORT REQUESTED</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="5" text-align="center" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>2nd</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="5" text-align="center" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>3rd</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell max-width="39" border="solid 1pt gray" padding="2pt" height="5" text-align="center" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>4th</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="5" text-align="center" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>5th</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="2pt" height="20" display-align="before">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>PERSONNEL: Salary and fringe</xsl:text>
                                                </fo:inline>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <fo:inline font-size="8pt">
                                                            <xsl:text> benefits. Applicant organization only.</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="20" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="SalariesWagesTotal">
                                                                <xsl:if test="../BudgetPeriodID  = 1">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-ea';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'ch>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="20" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="SalariesWagesTotal">
                                                                <xsl:if test="../BudgetPeriodID  = 2">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="20" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="SalariesWagesTotal">
                                                                <xsl:if test="../BudgetPeriodID  = 3">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="20" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="SalariesWagesTotal">
                                                                <xsl:if test="../BudgetPeriodID = 4">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="20" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="SalariesWagesTotal">
                                                                <xsl:if test="../BudgetPeriodID  = 5">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>CONS';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'ULTANT COSTS</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 1 and  ../Type =  &apos;Consultant Costs&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 2 and  ../Type =  &apos;Consultant Costs&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 3 and  ../Type = &apos;Consultant Costs&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 4 and  ../Type = &apos;Consultant Costs&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of s';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'elect="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 5 and  ../Type = &apos;Consultant Costs&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>EQUIPMENT</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:EquipmentCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 1">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:EquipmentCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 2">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="Budget';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'Summary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:EquipmentCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 3">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:EquipmentCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID = 4">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:EquipmentCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 5">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>SUPPLIES</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 1 and  ../Type =  &apos;Materials and Supplies&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := ':for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 2 and  ../Type =   &apos;Materials and Supplies&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 3 and  ../Type =  &apos;Materials and Supplies&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 4 and  ../Type =   &apos;Materials and Supplies&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 5 and  ../Type =  &apos;Materials and Supplies&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
            ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := '                                                         </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>TRAVEL</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:TravelCosts">
                                                                <xsl:if test="../BudgetPeriodID =1">
                                                                    <xsl:for-each select="Cost">
                                                                        <fo:inline>
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline>
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:TravelCosts">
                                                                <xsl:if test="../BudgetPeriodID =2">
                                                                    <xsl:for-each select="Cost">
                                                                        <fo:inline>
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline>
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:TravelCosts">
                                                                <xsl:if test="../BudgetPeriodID =3">
                                                                    <xsl:for-each select="Cost">
                                                                        <fo:inline>
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline>
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'BudgetPeriod">
                                                            <xsl:for-each select="rar:TravelCosts">
                                                                <xsl:if test="../BudgetPeriodID =4">
                                                                    <xsl:for-each select="Cost">
                                                                        <fo:inline>
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline>
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:TravelCosts">
                                                                <xsl:if test="../BudgetPeriodID =5">
                                                                    <xsl:for-each select="Cost">
                                                                        <fo:inline>
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline>
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-rows-spanned="2" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>PATIENT CARE COSTS</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="7pt">
                                                    <xsl:text>INPATIENT</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 1 and  ../Type =  &apos;Inpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 2 and  ../Type =  &apos;Inpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                        ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := '                                             <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 3 and  ../Type =   &apos;Inpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID = 4 and  ../Type =  &apos;Inpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 5 and  ../Type =  &apos;Inpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="7pt">
                                                    <xsl:text>OUTPATIENT</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt"';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := ' height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 1 and  ../Type =  &apos;Outpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 2 and  ../Type =  &apos;Outpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 3 and  ../Type =  &apos;Outpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 4 and  ../Type =  &apos;Outpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xs';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'l:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:ParticipantPatientCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 5 and  ../Type =  &apos;Outpatient&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="2pt" height="15" display-align="before">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>ALTERATIONS AND RENOVATIONS</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 1 and  ../Type =  &apos;Alterations and Renovations&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 2 and  ../Type =  &apos;Alterations and Renovations&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-ea';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'ch select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 3 and  ../Type =  &apos;Alterations and Renovations&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 4 and  ../Type =  &apos;Alterations and Renovations&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="rar:OtherDirectCosts">
                                                                <xsl:for-each select="Cost">
                                                                    <xsl:if test="../../BudgetPeriodID  = 5 and  ../Type =  &apos;Alterations and Renovations&apos;">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>OTHER EXPENSES</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>$</xsl:text>
                                                </fo:inline>
                                                <fo:inline>
                                                    <xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/rar:OtherDirectCosts[Type=&apos;Other Direct Costs&apos;]/Cost)), ''#,###,###,##0'')"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <f';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'o:inline>
                                                    <xsl:text>$</xsl:text>
                                                </fo:inline>
                                                <fo:inline>
                                                    <xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=2]/rar:OtherDirectCosts[Type=&apos;Other Direct Costs&apos;]/Cost)), ''#,###,###,##0'')"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>$</xsl:text>
                                                </fo:inline>
                                                <fo:inline>
                                                    <xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=3]/rar:OtherDirectCosts[Type=&apos;Other Direct Costs&apos;]/Cost)), ''#,###,###,##0'')"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=4]/rar:OtherDirectCosts[Type=&apos;Other Direct Costs&apos;]/Cost)), ''#,###,###,##0'')"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=5]/rar:OtherDirectCosts[Type=&apos;Other Direct Costs&apos;]/Cost)), ''#,###,###,##0'')"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell  font-size="8pt" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" height="15" display-align="before">
                                            <fo:block>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block  font-size="8pt" margin="0pt">
                                                    <fo:block>
                                                        <fo:inline>
                                                            <xsl:text>CONSORTIUM/</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                                <fo:inline>
                                                    <xsl:text>CONTRACTUAL COSTS</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>DIRECT</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:for-each select="DirectCosts">
                                                                    <xsl:if test="../../BudgetPeriodID = 1">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xs';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'l:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:for-each select="DirectCosts">
                                                                    <xsl:if test="../../BudgetPeriodID = 2">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:for-each select="DirectCosts">
                                                                    <xsl:if test="../../BudgetPeriodID = 3">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:if test="../BudgetPeriodID = 4">
                                                                    <xsl:for-each select="DirectCosts">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:for-each select="DirectCosts">
                                                                    <xsl:if test="../../BudgetPeriodID = 5">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
    ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := '                                             </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="2pt" height="42" display-align="before">
                                            <fo:block>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <fo:inline font-weight="bold">
                                                            <xsl:text>SUBTOTAL DIRECT COSTS</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                                <fo:inline>
                                                    <xsl:text>(Sum = Item 8a, Face Page)</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="42" text-align="right" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>$</xsl:text>
                                                </fo:inline>
                                                <fo:inline>
                                                    <xsl:value-of select="format-number(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/PeriodDirectCostsTotal -   nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/ConsortiumCosts/IndirectCosts), ''#,###,###,###,##0'')"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="2pt" height="42" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:if test="boolean(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=2]/PeriodDirectCostsTotal -   
nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=2]/ConsortiumCosts/IndirectCosts)) = true()">
                                                    <fo:inline>
                                                        <xsl:text>$</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="format-number(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=2]/PeriodDirectCostsTotal -   nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=2]/ConsortiumCosts/IndirectCosts), ''#,###,###,###,##0'')"/>
                                                    </fo:inline>
                                                </xsl:if>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="42" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:if test="boolean(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=3]/PeriodDirectCostsTotal -   
nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=3]/ConsortiumCosts/IndirectCosts)) = true()">
                                                    <fo:inline>
                                                        <xsl:text>$</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="format-number(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=3]/PeriodDirectCostsTotal -   nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=3]/ConsortiumCosts/IndirectCosts), ''#,###,###,##0'')"/>
                                                    </fo:inline>
                                                </xsl:if>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="42" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:if test="boolean(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=4]/PeriodDirectCostsTotal - 
nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=4]/ConsortiumCosts/IndirectCosts )  ) = true()">
                                                    <fo:inline>
                                                        <xsl:text>$</xsl:text>
                                                    </';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="format-number(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=4]/PeriodDirectCostsTotal - 
nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=4]/ConsortiumCosts/IndirectCosts), ''#,###,###,###,##0'')"/>
                                                    </fo:inline>
                                                </xsl:if>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell  font-size="8pt" border="solid 1pt gray" padding="2pt" height="42" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:if test="boolean(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=5]/PeriodDirectCostsTotal -   
nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=5]/ConsortiumCosts/IndirectCosts )  ) = true()">
                                                    <fo:inline>
                                                        <xsl:text>$</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="format-number(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=5]/PeriodDirectCostsTotal -   nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=5]/ConsortiumCosts/IndirectCosts), ''#,###,###,###,##0'')"/>
                                                    </fo:inline>
                                                </xsl:if>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell  font-size="8pt" number-columns-spanned="2" border="solid 1pt gray" padding="2pt" height="15" display-align="before">
                                            <fo:block>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <fo:inline>
                                                            <xsl:text>CONSORTIUM/</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                                <fo:inline>
                                                    <xsl:text>CONTRACTUAL COSTS</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell  font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>F&amp;A</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:for-each select="IndirectCosts">
                                                                    <xsl:if test="../../BudgetPeriodID = 1">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:for-each select="IndirectCosts">
                                                                    <xsl:if test="../../BudgetPeriodID = 2">
                                                                        <fo:inline font-siz';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'e="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:for-each select="IndirectCosts">
                                                                    <xsl:if test="../../BudgetPeriodID = 3">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:if test="../BudgetPeriodID = 4">
                                                                    <xsl:for-each select="IndirectCosts">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="ConsortiumCosts">
                                                                <xsl:for-each select="IndirectCosts">
                                                                    <xsl:if test="../../BudgetPeriodID = 5">
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:text>$</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:inline font-size="8pt">
                                                                            <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                        </fo:inline>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="2pt" height="15" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="9pt" font-weight="bold">
                                                    <xsl:text>TOTAL DIRECT COSTS</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" t';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'ext-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="PeriodDirectCostsTotal">
                                                                <xsl:if test="../BudgetPeriodID = 1">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="PeriodDirectCostsTotal">
                                                                <xsl:if test="../BudgetPeriodID = 2">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="PeriodDirectCostsTotal">
                                                                <xsl:if test="../BudgetPeriodID = 3">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" max-width="39" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="PeriodDirectCostsTotal">
                                                                <xsl:if test="../BudgetPeriodID = 4">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="8pt" border="solid 1pt gray" padding="2pt" height="15" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetPeriod">
                                                            <xsl:for-each select="PeriodDirectCostsTotal">
                                            ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := '                 <xsl:if test="../BudgetPeriodID = 5">
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:text>$</xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="8pt">
                                                                        <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                                    </fo:inline>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="7" border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                            <fo:block>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <fo:inline font-size="9pt" font-weight="bold">
                                                            <xsl:text>TOTAL DIRECT COSTS FOR ENTIRE PROPOSED PROJECT PERIOD </xsl:text>
                                                        </fo:inline>
                                                        <fo:inline font-size="9pt" font-weight="bold">
                                                            <xsl:text>&#160;&#160; -------------&gt;</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell border-bottom-width="thick" border-left-width="thick" border-right-width="thick" border-top-width="thick" font-size="8pt" border="solid 1pt gray" padding="2pt" height="18" text-align="right" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="BudgetSummary">
                                                        <xsl:for-each select="BudgetDirectCostsTotal">
                                                            <fo:inline font-size="8pt" font-weight="bold">
                                                                <xsl:text>$</xsl:text>
                                                            </fo:inline>
                                                            <fo:inline font-size="8pt" font-weight="bold">
                                                                <xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell font-size="8pt" number-columns-spanned="8" border="solid 1pt gray" padding="2pt" height="271" display-align="before">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>JUSTIFICATION. </xsl:text>
                                                </fo:inline>
                                                <fo:block/>
                                                <fo:inline>
                                                    <xsl:text>See attached for Budget Justification.</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                        </xsl:for-each>
                    </fo:block>
                    <fo:block id="SV_RefID_PageTotal"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template name="footerall">
        <fo:static-content flow-name="xsl-region-after">
            <fo:block>
                <xsl:for-each select="$XML">
                    <fo:inline-container>
                        <fo:block>
                            <xsl:text>&#x2029;</xsl:text>
                        </fo:block>
                    </fo:inline-container>
                    <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-column column-width="150"/>
                        <fo:table-body start-indent="0pt">
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="2" padding="2pt" height="1" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell padding="0" number-columns-spanned="2" height="1" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:tab';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 13 FOR UPDATE;
buffer := 'le-cell font-size="smaller" padding="0" text-align="left" display-align="center">
                                    <fo:block>
                                        <fo:inline font-size="7pt">
                                            <xsl:text>PHS 398 (Rev.11/07)&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Page:</xsl:text>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
                                    <fo:block>
                                        <fo:inline font-size="7pt" font-weight="bold">
                                            <xsl:text>Form Page: 5</xsl:text>
                                        </fo:inline>
                                        <fo:inline font-weight="bold">
                                            <xsl:text>&#160;</xsl:text>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </xsl:for-each>
            </fo:block>
        </fo:static-content>
    </xsl:template>
    <xsl:template name="double-backslash">
        <xsl:param name="text"/>
        <xsl:param name="text-length"/>
        <xsl:variable name="text-after-bs" select="substring-after($text, ''\'')"/>
        <xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
        <xsl:choose>
            <xsl:when test="$text-after-bs-length = 0">
                <xsl:choose>
                    <xsl:when test="substring($text, $text-length) = ''\''">
                        <xsl:value-of select="concat(substring($text,1,$text-length - 1), ''\\'')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$text"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), ''\\'')"/>
                <xsl:call-template name="double-backslash">
                    <xsl:with-param name="text" select="$text-after-bs"/>
                    <xsl:with-param name="text-length" select="$text-after-bs-length"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
