/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.internal.metadatatable.AppliedMigration;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.util.jdbc.TransactionCallback;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class DbBaseline {
    private static final Log LOG = LogFactory.getLog(DbBaseline.class);
    private final Connection connection;
    private final MetaDataTable metaDataTable;
    private final MigrationVersion baselineVersion;
    private final String baselineDescription;
    private final FlywayCallback[] callbacks;

    public DbBaseline(Connection connection, MetaDataTable metaDataTable, MigrationVersion baselineVersion, String baselineDescription, FlywayCallback[] callbacks) {
        this.connection = connection;
        this.metaDataTable = metaDataTable;
        this.baselineVersion = baselineVersion;
        this.baselineDescription = baselineDescription;
        this.callbacks = callbacks;
    }

    public void baseline() {
        for (final FlywayCallback callback : this.callbacks) {
            new TransactionTemplate(this.connection).execute(new TransactionCallback<Object>(){

                @Override
                public Object doInTransaction() throws SQLException {
                    callback.beforeInit(DbBaseline.this.connection);
                    callback.beforeBaseline(DbBaseline.this.connection);
                    return null;
                }
            });
        }
        new TransactionTemplate(this.connection).execute(new TransactionCallback<Void>(){

            @Override
            public Void doInTransaction() {
                if (DbBaseline.this.metaDataTable.hasAppliedMigrations()) {
                    throw new FlywayException("Unable to baseline metadata table " + DbBaseline.this.metaDataTable + " as it already contains migrations");
                }
                if (DbBaseline.this.metaDataTable.hasBaselineMarker()) {
                    AppliedMigration baselineMarker = DbBaseline.this.metaDataTable.getBaselineMarker();
                    if (DbBaseline.this.baselineVersion.equals(baselineMarker.getVersion()) && DbBaseline.this.baselineDescription.equals(baselineMarker.getDescription())) {
                        LOG.info("Metadata table " + DbBaseline.this.metaDataTable + " already initialized with (" + DbBaseline.this.baselineVersion + "," + DbBaseline.this.baselineDescription + "). Skipping.");
                        return null;
                    }
                    throw new FlywayException("Unable to baseline metadata table " + DbBaseline.this.metaDataTable + " with (" + DbBaseline.this.baselineVersion + "," + DbBaseline.this.baselineDescription + ") as it has already been initialized with (" + baselineMarker.getVersion() + "," + baselineMarker.getDescription() + ")");
                }
                if (DbBaseline.this.metaDataTable.hasSchemasMarker() && DbBaseline.this.baselineVersion.equals(MigrationVersion.fromVersion("0"))) {
                    throw new FlywayException("Unable to baseline metadata table " + DbBaseline.this.metaDataTable + " with version 0 as this version was used for schema creation");
                }
                DbBaseline.this.metaDataTable.addBaselineMarker(DbBaseline.this.baselineVersion, DbBaseline.this.baselineDescription);
                return null;
            }
        });
        LOG.info("Schema baselined with version: " + this.baselineVersion);
        for (final FlywayCallback callback : this.callbacks) {
            new TransactionTemplate(this.connection).execute(new TransactionCallback<Object>(){

                @Override
                public Object doInTransaction() throws SQLException {
                    callback.afterInit(DbBaseline.this.connection);
                    callback.afterBaseline(DbBaseline.this.connection);
                    return null;
                }
            });
        }
    }
}

