/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.config.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.core.framework.config.property.AbstractBaseConfig;

public class SimpleConfig
extends AbstractBaseConfig {
    protected final List<String> fileLocs;
    protected Properties propertiesUsed = new Properties();
    private Map<String, Object> objects = new LinkedHashMap<String, Object>();
    private Properties baseProperties = new Properties();
    private Map<String, Object> baseObjects = new HashMap<String, Object>();

    public SimpleConfig() {
        this.fileLocs = new ArrayList<String>();
    }

    public SimpleConfig(String fileLoc) {
        this(Collections.singletonList(fileLoc));
    }

    public SimpleConfig(List<String> fileLocs) {
        this.fileLocs = fileLocs;
    }

    public SimpleConfig(Properties properties) {
        this(new ArrayList<String>(), properties);
    }

    public SimpleConfig(String fileLoc, Properties baseProperties) {
        this(Collections.singletonList(fileLoc), baseProperties);
    }

    public SimpleConfig(List<String> fileLocs, Properties baseProperties) {
        this(fileLocs);
        this.baseProperties = baseProperties;
    }

    @Override
    public void parseConfig() throws IOException {
        throw new UnsupportedOperationException("Parsing is no longer supported by BaseConfig, please see JAXBConfigImpl instead.");
    }

    protected void configureBuiltIns(Properties properties) {
        properties.put("host.ip", RiceUtilities.getIpNumber());
        properties.put("host.name", RiceUtilities.getHostName());
    }

    public Map<String, Object> getBaseObjects() {
        return this.baseObjects;
    }

    public Properties getBaseProperties() {
        return this.baseProperties;
    }

    @Override
    public Properties getProperties() {
        return this.propertiesUsed;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    @Override
    public Map<String, Object> getObjects() {
        return this.objects;
    }

    @Override
    public Object getObject(String key) {
        return this.getObjects().get(key);
    }

    public void putProperties(Properties properties) {
        if (properties != null) {
            this.getProperties().putAll((Map<?, ?>)properties);
        }
    }

    public void putProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public void putObject(String key, Object value) {
        this.getObjects().put(key, value);
    }

    public void putObjects(Map<String, Object> objects) {
        if (objects != null) {
            this.getObjects().putAll(objects);
        }
    }

    public void removeObject(String key) {
        this.getObjects().remove(key);
    }

    public void removeProperty(String key) {
        this.getProperties().remove(key);
    }

    public void putConfig(Config config) {
        this.putProperties(config.getProperties());
        this.putObjects(config.getObjects());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fileLocs", this.fileLocs).toString();
    }
}

