/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.action;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.action.ActionType;
import org.w3c.dom.Element;

@XmlRootElement(name="validActions")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ValidActionsType", propOrder={"validActionCodes", "_futureElements"})
public final class ValidActions
extends AbstractDataTransferObject {
    private static final long serialVersionUID = 8074175291030982905L;
    @XmlElement(name="validActionCode", required=false)
    private final Set<String> validActionCodes;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ValidActions() {
        this.validActionCodes = null;
    }

    private ValidActions(Builder builder) {
        Set<ActionType> validActions = builder.getValidActions();
        HashSet<String> validActionCodes = new HashSet<String>();
        for (ActionType actionType : validActions) {
            validActionCodes.add(actionType.getCode());
        }
        this.validActionCodes = validActionCodes;
    }

    public Set<ActionType> getValidActions() {
        if (this.validActionCodes == null) {
            return Collections.emptySet();
        }
        HashSet<ActionType> validActions = new HashSet<ActionType>();
        for (String validActionCode : this.validActionCodes) {
            ActionType actionType = ActionType.fromCode(validActionCode, true);
            if (actionType == null) continue;
            validActions.add(actionType);
        }
        return Collections.unmodifiableSet(validActions);
    }

    static class Elements {
        static final String VALID_ACTION_CODES = "validActionCodes";
        static final String VALID_ACTION_CODE = "validActionCode";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "validActions";
        static final String TYPE_NAME = "ValidActionsType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder {
        private static final long serialVersionUID = -3227993220281961077L;
        private Set<ActionType> validActions;

        private Builder() {
            this.setValidActions(new HashSet<ActionType>());
        }

        public static Builder create() {
            return new Builder();
        }

        public ValidActions build() {
            return new ValidActions(this);
        }

        public Set<ActionType> getValidActions() {
            return this.validActions;
        }

        public void setValidActions(Set<ActionType> validActions) {
            if (validActions == null) {
                throw new IllegalArgumentException("validActions was null");
            }
            this.validActions = new HashSet<ActionType>(validActions);
        }

        public void addValidAction(ActionType validAction) {
            if (validAction == null) {
                throw new IllegalArgumentException("validAction was null");
            }
            this.validActions.add(validAction);
        }
    }
}

