/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import org.kuali.rice.core.api.mo.common.Coded;

public final class ActivationTypeEnum
implements Coded {
    public static final ActivationTypeEnum SEQUENTIAL = new ActivationTypeEnum("S", "Sequential", "SEQUENCE");
    public static final ActivationTypeEnum PARALLEL = new ActivationTypeEnum("P", "Parallel", "PARALLEL");
    public static final ActivationTypeEnum PRIORITY_PARALLEL = new ActivationTypeEnum("R", "Priority-Parallel", "PRIORITY-PARALLEL");
    private final String code;
    private final String name;
    private final String label;

    private ActivationTypeEnum(String code, String name, String label) {
        this.code = code;
        this.name = name;
        this.label = label;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "[ActivationTypeEnum: code=" + this.code + ", name=" + this.name + ", label=" + this.label + "]";
    }

    public static ActivationTypeEnum lookupCode(String code) {
        if (code == null) {
            throw new IllegalArgumentException("Activation type code must be non-null");
        }
        if (ActivationTypeEnum.SEQUENTIAL.code.equals(code)) {
            return SEQUENTIAL;
        }
        if (ActivationTypeEnum.PARALLEL.code.equals(code)) {
            return PARALLEL;
        }
        if (ActivationTypeEnum.PRIORITY_PARALLEL.code.equals(code)) {
            return PRIORITY_PARALLEL;
        }
        throw new IllegalArgumentException("Invalid activation code: '" + code + "'");
    }

    public static ActivationTypeEnum parse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Activation type string must be non-null");
        }
        if (ActivationTypeEnum.SEQUENTIAL.code.equalsIgnoreCase(string) || ActivationTypeEnum.SEQUENTIAL.name.equalsIgnoreCase(string) || ActivationTypeEnum.SEQUENTIAL.label.equalsIgnoreCase(string)) {
            return SEQUENTIAL;
        }
        if (ActivationTypeEnum.PARALLEL.code.equalsIgnoreCase(string) || ActivationTypeEnum.PARALLEL.name.equalsIgnoreCase(string) || ActivationTypeEnum.PARALLEL.label.equalsIgnoreCase(string)) {
            return PARALLEL;
        }
        if (ActivationTypeEnum.PRIORITY_PARALLEL.code.equalsIgnoreCase(string) || ActivationTypeEnum.PRIORITY_PARALLEL.name.equalsIgnoreCase(string) || ActivationTypeEnum.PRIORITY_PARALLEL.label.equalsIgnoreCase(string)) {
            return PRIORITY_PARALLEL;
        }
        throw new IllegalArgumentException("Invalid activation type: '" + string + "'");
    }
}

